/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.slimefuntranslation.implementation.packetlisteners.server;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.reflect.StructureModifier;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.guizhanss.slimefuntranslation.SlimefunTranslation;
import net.guizhanss.slimefuntranslation.core.users.User;
import net.guizhanss.slimefuntranslation.implementation.packetlisteners.server.AServerListener;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.chat.ComponentSerializer;

public class OpenWindowListener
extends AServerListener {
    public OpenWindowListener() {
        super(PacketType.Play.Server.OPEN_WINDOW);
    }

    @Override
    protected void process(@Nonnull PacketEvent event) {
        User user = this.getUser(event);
        if (user == null) {
            return;
        }
        SlimefunItem block = user.getRecentClickedBlock();
        if (block == null) {
            return;
        }
        PacketContainer packet = event.getPacket();
        StructureModifier modifier = packet.getChatComponents();
        WrappedChatComponent wrappedChatComponent = (WrappedChatComponent)modifier.read(0);
        BaseComponent[] components = ComponentSerializer.parse((String)wrappedChatComponent.getJson());
        String title = Stream.of(components).map(c -> c.toLegacyText()).collect(Collectors.joining());
        if (!block.getItemName().equals(title)) {
            return;
        }
        modifier.write(0, (Object)WrappedChatComponent.fromLegacyText((String)SlimefunTranslation.getTranslationService().getTranslatedItemName(user, block)));
    }
}

