/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.slimefuntranslation.libs.guizhanlib.updater;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.guizhanss.slimefuntranslation.libs.guizhanlib.updater.GuizhanBuildsUpdater;
import org.bukkit.scheduler.BukkitRunnable;

class GuizhanBuildsUpdaterTask
extends BukkitRunnable {
    private final GuizhanBuildsUpdater updater;
    private final HttpClient httpClient;
    private final boolean isDebug;
    private JsonObject projectInfo = null;
    private JsonObject buildInfo = null;

    GuizhanBuildsUpdaterTask(@Nonnull GuizhanBuildsUpdater updater) {
        this.updater = updater;
        this.httpClient = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(10L)).build();
        this.isDebug = Boolean.parseBoolean(System.getProperty("guizhanlib.updater.debug"));
    }

    public void run() {
        this.getProjectInfo();
        if (this.projectInfo != null && this.hasUpdate()) {
            if (this.updater.getUpdaterConfig().checkOnly()) {
                this.sendUpdateNotification();
            } else {
                this.update();
            }
        }
    }

    private void getProjectInfo() {
        block4: {
            try {
                URI baseUrl = new URI(this.updater.getUpdaterConfig().baseUrl());
                if (!this.isValidHost(baseUrl)) {
                    throw new IllegalArgumentException("Invalid base URL provided. Only provide the host.");
                }
                URI projectUrl = baseUrl.resolve("/api/project/" + this.updater.getOwner() + "/" + this.updater.getRepository() + "/" + this.updater.getBranch());
                JsonObject projectsResp = this.fetch(projectUrl);
                if (projectsResp == null) {
                    throw new IllegalStateException("Cannot get project information");
                }
                this.projectInfo = projectsResp.get("data").getAsJsonObject();
            }
            catch (Exception ex) {
                this.updater.log(Level.SEVERE, "An error has occurred while fetching project info.", new Object[0]);
                if (!this.isDebug) break block4;
                this.updater.log(Level.SEVERE, ex, ex.getMessage(), new Object[0]);
            }
        }
    }

    private boolean isValidHost(@Nonnull URI uri) {
        if (uri.getScheme() == null || !uri.getScheme().equals("http") && !uri.getScheme().equals("https")) {
            return false;
        }
        return uri.getPath().isEmpty() || uri.getPath().equals("/");
    }

    private boolean hasUpdate() {
        try {
            URI baseUrl = new URI(this.updater.getUpdaterConfig().baseUrl());
            if (!this.isValidHost(baseUrl)) {
                throw new IllegalArgumentException("Invalid base URL provided. Only provide the host.");
            }
            URI buildUrl = baseUrl.resolve("/api/build/" + this.updater.getOwner() + "/" + this.updater.getRepository() + "/" + this.updater.getBranch() + "/latest?status=success");
            JsonObject buildResp = this.fetch(buildUrl);
            if (buildResp == null) {
                throw new IllegalStateException("Cannot get latest successful build");
            }
            this.buildInfo = buildResp.get("data").getAsJsonObject();
            String pluginVersion = this.updater.getPlugin().getDescription().getVersion();
            String target = this.updater.getPlugin().getName() + "-" + pluginVersion + ".jar";
            return !target.equals(this.buildInfo.get("target").getAsString());
        }
        catch (Exception ex) {
            this.updater.log(Level.SEVERE, "An error has occurred while fetching the latest build.", new Object[0]);
            if (this.isDebug) {
                this.updater.log(Level.SEVERE, ex, ex.getMessage(), new Object[0]);
            }
            return false;
        }
    }

    private void sendUpdateNotification() {
        this.updater.log(Level.INFO, "%s needs to be updated!", this.updater.getPlugin().getName());
        this.updater.log(Level.INFO, "Downloading is disabled, you have to download the new version manually!", new Object[0]);
    }

    private void update() {
        this.updater.log(Level.INFO, "%s needs to be updated!", this.updater.getPlugin().getName());
        this.updater.log(Level.INFO, "Downloading %s - Build %d", this.updater.getPlugin().getName(), this.buildInfo.get("id").getAsInt());
        try {
            int bytesRead;
            URI baseUrl = new URI(this.updater.getUpdaterConfig().baseUrl());
            if (!this.isValidHost(baseUrl)) {
                throw new IllegalArgumentException("Invalid base URL provided. Only provide the host.");
            }
            URI downloadUrl = baseUrl.resolve("/api/download/" + this.updater.getOwner() + "/" + this.updater.getRepository() + "/" + this.updater.getBranch() + "/" + this.buildInfo.get("id").getAsInt());
            HttpRequest request = this.buildRequest(downloadUrl);
            HttpResponse<InputStream> response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofInputStream());
            if (response.statusCode() != 200) {
                throw new IllegalArgumentException("Cannot download build artifact.");
            }
            InputStream inputStream = response.body();
            FileOutputStream outputStream = new FileOutputStream(new File("plugins/" + this.updater.getPlugin().getServer().getUpdateFolder(), this.updater.getFile().getName()));
            byte[] buffer = new byte[4096];
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, bytesRead);
            }
        }
        catch (Exception ex) {
            this.updater.log(Level.SEVERE, "An error has occurred while downloading %s.", this.updater.getPlugin().getName());
            if (this.isDebug) {
                this.updater.log(Level.SEVERE, ex, ex.getMessage(), new Object[0]);
            }
            return;
        }
        this.updater.log(Level.INFO, " ", new Object[0]);
        this.updater.log(Level.INFO, "========== Guizhan Auto Update ==========", new Object[0]);
        this.updater.log(Level.INFO, "Successfully downloaded %s - Build %d", this.updater.getPlugin().getName(), this.buildInfo.get("id").getAsInt());
        this.updater.log(Level.INFO, "Restart the server to install the update", new Object[0]);
        this.updater.log(Level.INFO, " ", new Object[0]);
    }

    private HttpRequest buildRequest(URI uri) {
        return HttpRequest.newBuilder().uri(uri).header("Accept", "application/json").header("User-Agent", "Guizhan Updater").GET().build();
    }

    @Nullable
    private JsonObject fetch(@Nonnull URI uri) {
        HttpRequest request = this.buildRequest(uri);
        try {
            HttpResponse<String> response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() != 200) {
                return null;
            }
            return JsonParser.parseString((String)response.body()).getAsJsonObject();
        }
        catch (Exception ex) {
            this.updater.log(Level.SEVERE, "An error has occurred while fetching.", new Object[0]);
            if (this.isDebug) {
                this.updater.log(Level.SEVERE, ex, ex.getMessage(), new Object[0]);
            }
            return null;
        }
    }
}

