/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.slimefuntranslation.implementation.groups;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.groups.FlexItemGroup;
import io.github.thebusybiscuit.slimefun4.api.player.PlayerProfile;
import io.github.thebusybiscuit.slimefun4.core.guide.SlimefunGuide;
import io.github.thebusybiscuit.slimefun4.core.guide.SlimefunGuideMode;
import io.github.thebusybiscuit.slimefun4.core.services.sounds.SoundEffect;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.chat.ChatInput;
import io.github.thebusybiscuit.slimefun4.libraries.dough.data.persistent.PersistentDataAPI;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import io.github.thebusybiscuit.slimefun4.utils.ChatUtils;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import java.util.Arrays;
import java.util.Locale;
import java.util.logging.Level;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import net.guizhanss.slimefuntranslation.SlimefunTranslation;
import net.guizhanss.slimefuntranslation.core.factories.MessageFactory;
import net.guizhanss.slimefuntranslation.utils.constant.Keys;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataHolder;
import org.bukkit.plugin.Plugin;

public class SearchResultGroup
extends FlexItemGroup {
    private static final int[] HEADER = new int[]{0, 2, 3, 4, 5, 6, 8};
    private static final int GUIDE_BACK = 1;
    private static final int GUIDE_SEARCH = 7;
    private static final int RESULT_START = 9;
    private static final int RESULT_END = 44;
    private static final int[] FOOTER = new int[]{45, 46, 47, 48, 49, 50, 51, 52, 53};
    private static final MessageFactory MESSAGE_FACTORY = MessageFactory.get(SlimefunTranslation.getInstance());
    private final String query;

    @ParametersAreNonnullByDefault
    public SearchResultGroup(String query) {
        super(Keys.SEARCH_RESULT_GROUP, (ItemStack)new CustomItemStack(Material.BARRIER, "Fake Search Result (by SlimefunTranslation)", new String[0]));
        this.query = query;
    }

    @ParametersAreNonnullByDefault
    public boolean isVisible(Player p, PlayerProfile profile, SlimefunGuideMode guideMode) {
        return false;
    }

    @ParametersAreNonnullByDefault
    public void open(Player p, PlayerProfile profile, SlimefunGuideMode guideMode) {
        String searchTerm = ChatColor.stripColor((String)this.query.toLowerCase(Locale.ROOT));
        ChestMenu menu = new ChestMenu(Slimefun.getLocalization().getMessage(p, "guide.search.inventory").replace("%item%", ChatUtils.crop((ChatColor)ChatColor.WHITE, (String)this.query)));
        menu.setEmptySlotsClickable(false);
        this.setupMenu(menu, p, profile, guideMode);
        profile.getGuideHistory().add((ItemGroup)this, 1);
        int index = 9;
        for (SlimefunItem slimefunItem : Slimefun.getRegistry().getEnabledSlimefunItems()) {
            if (index == 44) break;
            if (slimefunItem.isHidden() || !slimefunItem.getItemGroup().isAccessible(p) || !this.isSearchFilterApplicable(p, slimefunItem, searchTerm)) continue;
            CustomItemStack itemstack = new CustomItemStack(slimefunItem.getItem(), meta -> {
                meta.setDisplayName(SlimefunTranslation.getTranslationService().getTranslatedItemName(SlimefunTranslation.getUserService().getUser(p), slimefunItem));
                ItemGroup itemGroup = slimefunItem.getItemGroup();
                meta.setLore(Arrays.asList("", String.valueOf(ChatColor.DARK_GRAY) + "\u21e8 " + String.valueOf(ChatColor.WHITE) + itemGroup.getDisplayName(p)));
                meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES, ItemFlag.HIDE_ENCHANTS, ItemFlag.HIDE_POTION_EFFECTS});
                PersistentDataAPI.setBoolean((PersistentDataHolder)meta, (NamespacedKey)Keys.SEARCH_DISPLAY, (boolean)true);
            });
            menu.addItem(index, (ItemStack)itemstack);
            menu.addMenuClickHandler(index, (pl, slot, itm, action) -> {
                try {
                    SlimefunGuide.displayItem((PlayerProfile)profile, (SlimefunItem)slimefunItem, (boolean)true);
                }
                catch (Exception | LinkageError x) {
                    MESSAGE_FACTORY.sendMessage((CommandSender)pl, "sftranslation.commands.search.error", new Object[0]);
                    SlimefunTranslation.log(Level.WARNING, x, "Failed to open guide for item" + slimefunItem.getId(), new Object[0]);
                }
                return false;
            });
            ++index;
        }
        menu.open(new Player[]{p});
    }

    @ParametersAreNonnullByDefault
    private boolean isSearchFilterApplicable(Player p, SlimefunItem slimefunItem, String query) {
        String originalItemName = SlimefunTranslation.getTranslationService().getTranslatedItemName(SlimefunTranslation.getUserService().getUser(p), slimefunItem);
        String itemName = ChatColor.stripColor((String)originalItemName).toLowerCase(Locale.ROOT);
        return !itemName.isEmpty() && itemName.contains(query);
    }

    @ParametersAreNonnullByDefault
    private void setupMenu(ChestMenu menu, Player p, PlayerProfile profile, SlimefunGuideMode guideMode) {
        for (int slot2 : HEADER) {
            menu.addItem(slot2, ChestMenuUtils.getBackground(), ChestMenuUtils.getEmptyClickHandler());
        }
        for (int slot2 : FOOTER) {
            menu.addItem(slot2, ChestMenuUtils.getBackground(), ChestMenuUtils.getEmptyClickHandler());
        }
        menu.addMenuOpeningHandler(arg_0 -> ((SoundEffect)SoundEffect.GUIDE_BUTTON_CLICK_SOUND).playFor(arg_0));
        menu.addItem(1, ChestMenuUtils.getBackButton((Player)p, (String[])new String[]{"", String.valueOf(ChatColor.GRAY) + Slimefun.getLocalization().getMessage(p, "guide.back.guide")}), (pl, slot, item, action) -> {
            profile.getGuideHistory().goBack(Slimefun.getRegistry().getSlimefunGuide(guideMode));
            return false;
        });
        menu.addItem(7, ChestMenuUtils.getSearchButton((Player)p), (pl, slot, item, action) -> {
            pl.closeInventory();
            Slimefun.getLocalization().sendMessage((CommandSender)pl, "guide.search.message");
            ChatInput.waitForPlayer((Plugin)Slimefun.instance(), (Player)pl, newQuery -> pl.chat("/sftranslation search " + newQuery));
            return false;
        });
    }
}

