/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.slimefuntranslation.api.config;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.bukkit.configuration.ConfigurationSection;

public final class TranslationConditions {
    private static final String KEY_MATCH_NAME = "match-name";
    private static final String KEY_MATCH_LORE = "match-lore";
    private static final String KEY_FORCE_LOAD = "force-load";
    private static final String KEY_PARTIAL_OVERRIDE = "partial-override";
    private boolean matchName;
    private boolean matchLore;
    private boolean forceLoad;
    private boolean partialOverride;

    @Nonnull
    public static TranslationConditions load(@Nullable ConfigurationSection section) {
        return TranslationConditions.load(TranslationConditions.builder().build(), section);
    }

    public static TranslationConditions load(@Nonnull TranslationConditions parent, @Nullable ConfigurationSection section) {
        Preconditions.checkArgument((parent != null ? 1 : 0) != 0, (Object)"parent cannot be null");
        if (section == null) {
            return parent;
        }
        return TranslationConditions.builder().matchName(section.getBoolean(KEY_MATCH_NAME, parent.matchName)).matchLore(section.getBoolean(KEY_MATCH_LORE, parent.matchLore)).forceLoad(section.getBoolean(KEY_FORCE_LOAD, parent.forceLoad)).partialOverride(section.getBoolean(KEY_PARTIAL_OVERRIDE, parent.partialOverride)).build();
    }

    @Generated
    public static TranslationConditionsBuilder builder() {
        return new TranslationConditionsBuilder();
    }

    @Generated
    public boolean isMatchName() {
        return this.matchName;
    }

    @Generated
    public boolean isMatchLore() {
        return this.matchLore;
    }

    @Generated
    public boolean isForceLoad() {
        return this.forceLoad;
    }

    @Generated
    public boolean isPartialOverride() {
        return this.partialOverride;
    }

    @Generated
    public void setMatchName(boolean matchName) {
        this.matchName = matchName;
    }

    @Generated
    public void setMatchLore(boolean matchLore) {
        this.matchLore = matchLore;
    }

    @Generated
    public void setForceLoad(boolean forceLoad) {
        this.forceLoad = forceLoad;
    }

    @Generated
    public void setPartialOverride(boolean partialOverride) {
        this.partialOverride = partialOverride;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TranslationConditions)) {
            return false;
        }
        TranslationConditions other = (TranslationConditions)o;
        if (this.isMatchName() != other.isMatchName()) {
            return false;
        }
        if (this.isMatchLore() != other.isMatchLore()) {
            return false;
        }
        if (this.isForceLoad() != other.isForceLoad()) {
            return false;
        }
        return this.isPartialOverride() == other.isPartialOverride();
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isMatchName() ? 79 : 97);
        result = result * 59 + (this.isMatchLore() ? 79 : 97);
        result = result * 59 + (this.isForceLoad() ? 79 : 97);
        result = result * 59 + (this.isPartialOverride() ? 79 : 97);
        return result;
    }

    @Generated
    public String toString() {
        return "TranslationConditions(matchName=" + this.isMatchName() + ", matchLore=" + this.isMatchLore() + ", forceLoad=" + this.isForceLoad() + ", partialOverride=" + this.isPartialOverride() + ")";
    }

    @Generated
    public TranslationConditions() {
    }

    @Generated
    public TranslationConditions(boolean matchName, boolean matchLore, boolean forceLoad, boolean partialOverride) {
        this.matchName = matchName;
        this.matchLore = matchLore;
        this.forceLoad = forceLoad;
        this.partialOverride = partialOverride;
    }

    @Generated
    public static class TranslationConditionsBuilder {
        @Generated
        private boolean matchName;
        @Generated
        private boolean matchLore;
        @Generated
        private boolean forceLoad;
        @Generated
        private boolean partialOverride;

        @Generated
        TranslationConditionsBuilder() {
        }

        @Generated
        public TranslationConditionsBuilder matchName(boolean matchName) {
            this.matchName = matchName;
            return this;
        }

        @Generated
        public TranslationConditionsBuilder matchLore(boolean matchLore) {
            this.matchLore = matchLore;
            return this;
        }

        @Generated
        public TranslationConditionsBuilder forceLoad(boolean forceLoad) {
            this.forceLoad = forceLoad;
            return this;
        }

        @Generated
        public TranslationConditionsBuilder partialOverride(boolean partialOverride) {
            this.partialOverride = partialOverride;
            return this;
        }

        @Generated
        public TranslationConditions build() {
            return new TranslationConditions(this.matchName, this.matchLore, this.forceLoad, this.partialOverride);
        }

        @Generated
        public String toString() {
            return "TranslationConditions.TranslationConditionsBuilder(matchName=" + this.matchName + ", matchLore=" + this.matchLore + ", forceLoad=" + this.forceLoad + ", partialOverride=" + this.partialOverride + ")";
        }
    }
}

