/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.slimefuntranslation.api.config;

import com.google.common.base.Preconditions;
import io.github.thebusybiscuit.slimefun4.api.SlimefunAddon;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.libraries.dough.collections.Pair;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.guizhanss.slimefuntranslation.SlimefunTranslation;
import net.guizhanss.slimefuntranslation.api.config.TranslationConditions;
import net.guizhanss.slimefuntranslation.api.config.TranslationConfigurationDefaults;
import net.guizhanss.slimefuntranslation.api.config.TranslationConfigurationFields;
import net.guizhanss.slimefuntranslation.api.config.Translations;
import net.guizhanss.slimefuntranslation.api.translation.ItemTranslation;
import net.guizhanss.slimefuntranslation.core.Registry;
import net.guizhanss.slimefuntranslation.implementation.translations.FixedItemTranslation;
import net.guizhanss.slimefuntranslation.utils.ConfigUtils;
import net.guizhanss.slimefuntranslation.utils.GeneralUtils;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;

public class TranslationConfiguration {
    private final String name;
    private final String lang;
    private final Translations translations;
    private State state = State.UNREGISTERED;
    private SlimefunAddon addon = null;

    @Nonnull
    @ParametersAreNonnullByDefault
    public static Optional<TranslationConfiguration> fromFileConfiguration(String language, FileConfiguration config) {
        return TranslationConfiguration.fromFileConfiguration(language, config, TranslationConfigurationFields.DEFAULT, TranslationConfigurationDefaults.DEFAULT);
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public static Optional<TranslationConfiguration> fromFileConfiguration(String language, FileConfiguration config, TranslationConfigurationFields fields, TranslationConfigurationDefaults defaults) {
        ConfigurationSection messagesSection;
        ConfigurationSection loreSection;
        ConfigurationSection itemsSection;
        ConfigurationSection itemGroupsSection;
        Preconditions.checkArgument((config != null ? 1 : 0) != 0, (Object)"config cannot be null");
        String name = config.getString("name", defaults.getName());
        String lang = SlimefunTranslation.getConfigService().getMappedLanguage(language);
        if (SlimefunTranslation.getConfigService().getDisabledLanguages().contains(lang)) {
            SlimefunTranslation.debug("Language {0} is disabled, ignoring.", lang);
            return Optional.empty();
        }
        String itemIdPrefix = config.getString(fields.getPrefix(), defaults.getPrefix());
        String itemIdSuffix = config.getString(fields.getSuffix(), defaults.getSuffix());
        ConfigurationSection guidesSection = config.getConfigurationSection(fields.getGuides());
        if (GeneralUtils.isAllNull(guidesSection, itemGroupsSection = config.getConfigurationSection(fields.getItemGroups()), itemsSection = config.getConfigurationSection(fields.getItems()), loreSection = config.getConfigurationSection(fields.getLore()), messagesSection = config.getConfigurationSection(fields.getMessages()))) {
            SlimefunTranslation.log(Level.WARNING, "No translations found in " + name, new Object[0]);
            return Optional.empty();
        }
        TranslationConditions fileConditions = TranslationConditions.load(config.getConfigurationSection(fields.getConditions()));
        SlimefunTranslation.debug("Current file condition: {0}", fileConditions);
        Translations translations = new Translations();
        Map<String, ItemTranslation> guideTranslations = translations.getGuide();
        Map<String, String> itemGroupTranslations = translations.getItemGroup();
        Map<String, ItemTranslation> itemTranslations = translations.getItem();
        Map<String, String> loreTranslations = translations.getLore();
        Map<String, String> messageTranslations = translations.getMessage();
        SlimefunTranslation.log(Level.INFO, "Loading translation configuration \"{0}\", language: {1}", name, lang);
        if (guidesSection != null) {
            TranslationConfiguration.loadGuides(guideTranslations, guidesSection);
        }
        if (itemGroupsSection != null) {
            for (String group : itemGroupsSection.getKeys(true)) {
                SlimefunTranslation.debug("Loading item group translation {0}", group);
                String translation = itemGroupsSection.getString(group);
                itemGroupTranslations.put(group, translation);
            }
        }
        if (itemsSection != null) {
            TranslationConfiguration.loadItems(itemTranslations, itemsSection, fields, fileConditions, itemIdPrefix, itemIdSuffix);
        }
        if (loreSection != null) {
            for (String loreId : loreSection.getKeys(true)) {
                SlimefunTranslation.debug("Loading lore translation {0}", loreId);
                String lore = loreSection.getString(loreId);
                loreTranslations.put(loreId, lore);
            }
        }
        if (messagesSection != null) {
            for (String messageId : messagesSection.getKeys(true)) {
                SlimefunTranslation.debug("Loading message translation {0}", messageId);
                String message = messagesSection.getString(messageId);
                messageTranslations.put(messageId, message);
            }
        }
        return Optional.of(new TranslationConfiguration(name, lang, translations));
    }

    private static void loadGuides(Map<String, ItemTranslation> translations, ConfigurationSection guidesSection) {
        for (String mode : guidesSection.getKeys(false)) {
            SlimefunTranslation.debug("Loading guide translation for mode {0}", mode);
            ConfigurationSection guideSection = guidesSection.getConfigurationSection(mode);
            if (guideSection == null) {
                SlimefunTranslation.log(Level.SEVERE, "Invalid guide section {0} in configuration file.", mode);
                continue;
            }
            String displayName = guideSection.getString("name", "");
            List lore = guideSection.getStringList("lore");
            FixedItemTranslation translation = new FixedItemTranslation(displayName, lore);
            translations.put(mode, translation);
        }
    }

    private static void loadItems(Map<String, ItemTranslation> translations, ConfigurationSection itemsSection, TranslationConfigurationFields fields, TranslationConditions fileConditions, String prefix, String suffix) {
        int count = 0;
        for (String id : itemsSection.getKeys(false)) {
            Map<Object, Pair> replacements;
            String itemId = prefix + id + suffix;
            SlimefunTranslation.debug("Loading item translation {0}", itemId);
            ConfigurationSection itemSection = itemsSection.getConfigurationSection(id);
            if (itemSection == null) {
                SlimefunTranslation.log(Level.SEVERE, "Invalid item section {0} in configuration file.", id);
                continue;
            }
            TranslationConditions itemConditions = TranslationConditions.load(fileConditions, itemSection.getConfigurationSection(fields.getConditions()));
            SlimefunTranslation.debug("Current item condition: {0}", itemConditions);
            boolean forceLoad = itemConditions.isForceLoad();
            SlimefunItem sfItem = SlimefunItem.getById((String)itemId);
            if (sfItem == null && !forceLoad) {
                SlimefunTranslation.debug("Item {0} is not registered, ignoring.", itemId);
                continue;
            }
            String displayName = itemSection.getString("name", "");
            List lore = itemSection.getStringList("lore");
            HashMap<Integer, String> overrides = new HashMap<Integer, String>();
            if (itemSection.contains("lore-overrides")) {
                try {
                    replacements = ConfigUtils.getMap(itemSection.getConfigurationSection("lore-overrides"));
                    for (Map.Entry entry : replacements.entrySet()) {
                        overrides.put(Integer.parseInt((String)entry.getKey()), (String)entry.getValue());
                    }
                }
                catch (NullPointerException | NumberFormatException ex) {
                    SlimefunTranslation.log(Level.SEVERE, "Invalid lore overrides of item {0}.", itemId);
                    continue;
                }
            }
            replacements = new HashMap();
            if (itemSection.contains("lore-replacements")) {
                try {
                    for (String idx : itemSection.getConfigurationSection("lore-replacements").getKeys(false)) {
                        int i = Integer.parseInt(idx);
                        ConfigurationSection section = itemSection.getConfigurationSection("lore-replacements." + idx);
                        replacements.put(i, new Pair((Object)section.getString("original"), (Object)section.getString("replaced")));
                    }
                }
                catch (NullPointerException | NumberFormatException ex) {
                    SlimefunTranslation.log(Level.SEVERE, "Invalid lore replacements of item {0}", itemId);
                    continue;
                }
            }
            if (!itemConditions.isPartialOverride() && !forceLoad) {
                itemConditions.setPartialOverride(SlimefunTranslation.getConfigService().getPartialOverrideMaterials().contains(sfItem.getItem().getType()));
            }
            FixedItemTranslation translation = new FixedItemTranslation(displayName, lore, overrides, replacements, itemConditions);
            translations.put(itemId, translation);
            ++count;
        }
        SlimefunTranslation.debug("Loaded {0} item translations.", count);
    }

    public void register(@Nonnull SlimefunAddon addon) {
        if (this.state != State.UNREGISTERED) {
            throw new IllegalStateException("TranslationConfiguration is already registered");
        }
        Registry registry = SlimefunTranslation.getRegistry();
        this.registerTranslations(registry.getGuideTranslations(), this.lang, this.translations.getGuide());
        this.registerTranslations(registry.getItemGroupTranslations(), this.lang, this.translations.getItemGroup());
        this.registerTranslations(registry.getItemTranslations(), this.lang, this.translations.getItem());
        this.registerTranslations(registry.getLoreTranslations(), this.lang, this.translations.getLore());
        Map<String, Map<String, Map<String, String>>> allMessageTranslations = registry.getMessageTranslations();
        Map pluginMessageTranslations = allMessageTranslations.computeIfAbsent(addon.getName(), k -> new HashMap());
        this.registerTranslations(pluginMessageTranslations, this.lang, this.translations.getMessage());
        for (Map.Entry<String, ItemTranslation> entry : this.translations.getItem().entrySet()) {
            SlimefunItem sfItem = SlimefunItem.getById((String)entry.getKey());
            if (sfItem == null) continue;
            String itemName = sfItem.getItemName();
            registry.getItemNameTranslations().computeIfAbsent(this.lang, k -> new HashMap()).put(itemName, entry.getValue());
        }
        this.setAddon(addon);
        this.setState(State.REGISTERED);
    }

    private <V> void registerTranslations(Map<String, Map<String, V>> allTranslations, String lang, Map<String, V> translations) {
        Map currentTranslations = allTranslations.computeIfAbsent(lang, k -> new HashMap());
        currentTranslations.putAll(translations);
    }

    public String getName() {
        return this.name;
    }

    public String getLang() {
        return this.lang;
    }

    public Translations getTranslations() {
        return this.translations;
    }

    public State getState() {
        return this.state;
    }

    public SlimefunAddon getAddon() {
        return this.addon;
    }

    void setState(State state) {
        this.state = state;
    }

    void setAddon(SlimefunAddon addon) {
        this.addon = addon;
    }

    TranslationConfiguration(String name, String lang, Translations translations) {
        this.name = name;
        this.lang = lang;
        this.translations = translations;
    }

    public static enum State {
        UNREGISTERED,
        REGISTERED;

    }
}

