/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.slimefuntranslation.core.factories;

import com.google.common.base.Preconditions;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.guizhanss.slimefuntranslation.SlimefunTranslation;
import net.guizhanss.slimefuntranslation.core.users.User;
import net.guizhanss.slimefuntranslation.libs.guizhanlib.minecraft.utils.ChatUtil;
import net.guizhanss.slimefuntranslation.utils.TranslationUtils;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class MessageFactory {
    private static final Map<String, MessageFactory> INSTANCES = new HashMap<String, MessageFactory>();
    private final Plugin plugin;

    private MessageFactory(Plugin plugin) {
        this.plugin = plugin;
    }

    @Nonnull
    public static MessageFactory get(@Nonnull Plugin plugin) {
        Preconditions.checkArgument((plugin != null ? 1 : 0) != 0, (Object)"plugin cannot be null");
        return INSTANCES.computeIfAbsent(plugin.getName(), k -> new MessageFactory(plugin));
    }

    @ParametersAreNonnullByDefault
    public void sendMessage(CommandSender sender, String key, Object ... args) {
        Preconditions.checkArgument((sender != null ? 1 : 0) != 0, (Object)"sender cannot be null");
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"key cannot be null");
        sender.sendMessage(this.getMessage(sender, key, args));
    }

    @ParametersAreNonnullByDefault
    public void sendActionbarMessage(User user, String key, Object ... args) {
        Preconditions.checkArgument((user != null ? 1 : 0) != 0, (Object)"user cannot be null");
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"key cannot be null");
        user.getPlayer().spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)this.getMessage(user, key, args)));
    }

    @ParametersAreNonnullByDefault
    public String getMessage(CommandSender sender, String key, Object ... args) {
        Preconditions.checkArgument((sender != null ? 1 : 0) != 0, (Object)"sender cannot be null");
        User user = null;
        if (sender instanceof Player) {
            Player p = (Player)sender;
            user = SlimefunTranslation.getUserService().getUser(p);
        }
        return this.getMessage(user, key, args);
    }

    @Nonnull
    public String getMessage(@Nullable User user, @Nonnull String key, Object ... args) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"key cannot be null");
        Map<String, Map<String, Map<String, String>>> messageTranslations = SlimefunTranslation.getRegistry().getMessageTranslations();
        if (!messageTranslations.containsKey(this.plugin.getName())) {
            return key;
        }
        Optional transl = TranslationUtils.findTranslation(messageTranslations.get(this.plugin.getName()), user, key);
        if (transl.isEmpty()) {
            return key;
        }
        String message = MessageFormat.format((String)transl.get(), args);
        if (user != null) {
            message = SlimefunTranslation.getIntegrationService().applyPlaceholders(user, message);
        }
        return ChatUtil.color(message);
    }
}

