/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.slimefuntranslation.libs.guizhanlib.updater;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.guizhanss.slimefuntranslation.libs.guizhanlib.updater.LocaleKey;
import net.guizhanss.slimefuntranslation.libs.guizhanlib.updater.UpdaterConfig;
import net.guizhanss.slimefuntranslation.libs.guizhanlib.updater.UpdaterLocalizations;
import net.guizhanss.slimefuntranslation.libs.guizhanlib.updater.UpdaterTask;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public abstract class AbstractGuizhanBuildsUpdater {
    private final Plugin plugin;
    private final File file;
    private final String user;
    private final String repo;
    private final String branch;
    private final UpdaterConfig config;
    private final Logger logger;

    @ParametersAreNonnullByDefault
    protected AbstractGuizhanBuildsUpdater(Plugin plugin, File file, String user, String repo, String branch) {
        this(plugin, file, user, repo, branch, UpdaterConfig.DEFAULT);
    }

    @ParametersAreNonnullByDefault
    protected AbstractGuizhanBuildsUpdater(Plugin plugin, File file, String user, String repo, String branch, UpdaterConfig updaterConfig) {
        this.plugin = plugin;
        this.file = file;
        this.user = user;
        this.repo = repo;
        this.branch = branch;
        this.config = updaterConfig;
        this.logger = plugin.getLogger();
        this.prepareUpdateFolder();
    }

    @Deprecated
    @ParametersAreNonnullByDefault
    protected AbstractGuizhanBuildsUpdater(Plugin plugin, File file, String user, String repo, String branch, boolean checkOnly) {
        this(plugin, file, user, repo, branch, UpdaterConfig.builder().checkOnly(checkOnly).build());
    }

    @Deprecated
    @ParametersAreNonnullByDefault
    protected AbstractGuizhanBuildsUpdater(Plugin plugin, File file, String user, String repo, String branch, boolean checkOnly, String lang) {
        this(plugin, file, user, repo, branch, checkOnly);
    }

    private void prepareUpdateFolder() {
        File dir = new File("plugins/" + Bukkit.getUpdateFolder());
        if (!dir.exists()) {
            dir.mkdirs();
        }
    }

    @Nonnull
    public abstract String getBuildsURL();

    @Nonnull
    public abstract String getR2URL();

    @Nonnull
    public abstract String getLanguage();

    public void start() {
        this.plugin.getServer().getScheduler().runTaskAsynchronously(this.plugin, (Runnable)new UpdaterTask(this));
    }

    @Nonnull
    public String getReposFileURL() {
        return this.getBuildsURL() + "/repos.json";
    }

    @Nonnull
    public String getRepoKey() {
        return MessageFormat.format("{0}/{1}:{2}", this.user, this.repo, this.branch);
    }

    @Nonnull
    public String getBuildsInfo(@Nonnull String directory) {
        return MessageFormat.format("{0}/{1}/builds.json", this.getR2URL(), directory);
    }

    public void log(Level level, String message, Object ... args) {
        this.logger.log(level, () -> MessageFormat.format(message, args));
    }

    public void log(Level level, Exception exception, String message, Object ... args) {
        this.logger.log(level, exception, () -> MessageFormat.format(message, args));
    }

    public void log(Level level, LocaleKey key, Object ... args) {
        this.log(level, this.getLocalizedString(key), args);
    }

    public void log(Level level, Exception exception, LocaleKey key, Object ... args) {
        this.log(level, exception, this.getLocalizedString(key), args);
    }

    @ParametersAreNonnullByDefault
    @Nonnull
    public String getTargetUrl(String directory, String target) {
        return MessageFormat.format("{0}/{1}/{2}", this.getR2URL(), directory, target);
    }

    @ParametersAreNonnullByDefault
    @Nonnull
    public String getLocalizedString(LocaleKey key) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"The localization key cannot be null.");
        return UpdaterLocalizations.get(this.getLanguage(), key);
    }

    @Nullable
    public String getChecksum() {
        try {
            int bytesCount;
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            FileInputStream fis = new FileInputStream(this.file);
            byte[] byteArray = new byte[1024];
            while ((bytesCount = fis.read(byteArray)) != -1) {
                digest.update(byteArray, 0, bytesCount);
            }
            fis.close();
            byte[] bytes = digest.digest();
            StringBuilder sb = new StringBuilder();
            for (byte aByte : bytes) {
                sb.append(Integer.toString((aByte & 0xFF) + 256, 16).substring(1));
            }
            return sb.toString();
        }
        catch (IOException | NoSuchAlgorithmException ex) {
            this.log(Level.SEVERE, ex, LocaleKey.CANNOT_CALCULATE_CHECKSUM, new Object[0]);
            return null;
        }
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    public File getFile() {
        return this.file;
    }

    public String getUser() {
        return this.user;
    }

    public String getRepo() {
        return this.repo;
    }

    public String getBranch() {
        return this.branch;
    }

    public UpdaterConfig getConfig() {
        return this.config;
    }
}

