/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.slimefuntranslation.libs.guizhanlib.minecraft.commands;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;

public final class Usage {
    private static final Pattern USAGE_ARG_PATTERN = Pattern.compile("<[^>]*>|\\[[^]]*\\]|\\S+");
    private final String usageStr;

    public Usage(@Nonnull String usage) {
        Preconditions.checkArgument((usage != null ? 1 : 0) != 0, (Object)"usage cannot be null");
        this.usageStr = usage.trim();
    }

    @Nonnull
    public String get() {
        return this.usageStr;
    }

    public boolean isValid(@Nonnull String[] args) {
        if (args.length < this.getRequiredArgsCount()) {
            return false;
        }
        return args.length <= this.parseUsage().length;
    }

    private String[] parseUsage() {
        ArrayList<String> args = new ArrayList<String>();
        Matcher matcher = USAGE_ARG_PATTERN.matcher(this.usageStr);
        while (matcher.find()) {
            args.add(matcher.group());
        }
        return args.toArray(new String[0]);
    }

    private int getRequiredArgsCount() {
        int count = 0;
        for (String arg : this.parseUsage()) {
            if (!arg.startsWith("<")) continue;
            ++count;
        }
        return count;
    }
}

