/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.slimefuntranslation.implementation.listeners;

import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.chat.ChatInput;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.guizhanss.slimefuntranslation.SlimefunTranslation;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class SearchListener
implements Listener {
    public SearchListener(@Nonnull SlimefunTranslation plugin) {
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onSearch(@Nonnull InventoryClickEvent e) {
        ItemStack item = e.getCurrentItem();
        if (item == null || item.getType().isAir()) {
            return;
        }
        Optional sfId = Slimefun.getItemDataService().getItemData(item);
        SlimefunTranslation.debug("player clicked on item with sfId: " + sfId.orElse("null"), new Object[0]);
        if (sfId.isEmpty() || !((String)sfId.get()).equals("_UI_SEARCH")) {
            return;
        }
        Player p = (Player)e.getWhoClicked();
        e.setCancelled(true);
        p.closeInventory();
        SlimefunTranslation.debug("intercepting search", new Object[0]);
        Slimefun.getLocalization().sendMessage((CommandSender)p, "guide.search.message");
        ChatInput.waitForPlayer((Plugin)Slimefun.instance(), (Player)p, query -> p.chat("/sftranslation search " + query));
    }
}

