/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.slimefuntranslation.core.users;

import com.google.common.base.Preconditions;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.core.services.localization.Language;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class User {
    private final Player player;
    private final UUID uuid;
    private String locale;
    private SlimefunItem recentClickedBlock;

    public User(@Nonnull Player player) {
        this.player = player;
        this.uuid = player.getUniqueId();
        this.init();
    }

    public User(@Nonnull UUID uuid) {
        this.player = Bukkit.getPlayer((UUID)uuid);
        this.uuid = uuid;
        this.init();
    }

    private void init() {
        this.updateLocale();
    }

    public void updateLocale() {
        Language lang = Slimefun.getLocalization().getLanguage(this.player);
        if (lang != null) {
            this.setLocale(lang.getId());
        } else {
            this.setLocale(Slimefun.getLocalization().getDefaultLanguage().getId());
        }
    }

    public void setLocale(@Nonnull String newLocale) {
        Preconditions.checkArgument((newLocale != null ? 1 : 0) != 0, (Object)"Locale cannot be null");
        this.locale = newLocale;
    }

    public void setRecentClickedBlock(@Nullable SlimefunItem block) {
        this.recentClickedBlock = block;
    }

    public Player getPlayer() {
        return this.player;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public String getLocale() {
        return this.locale;
    }

    public SlimefunItem getRecentClickedBlock() {
        return this.recentClickedBlock;
    }

    public String toString() {
        return "User(player=" + this.getPlayer() + ", uuid=" + this.getUuid() + ", locale=" + this.getLocale() + ", recentClickedBlock=" + this.getRecentClickedBlock() + ")";
    }
}

