/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.slimefuntranslation.utils;

import com.google.common.base.Preconditions;
import io.github.thebusybiscuit.slimefun4.libraries.dough.common.CommonPatterns;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.guizhanss.slimefuntranslation.SlimefunTranslation;
import net.guizhanss.slimefuntranslation.utils.constant.Patterns;
import net.guizhanss.slimefuntranslation.utils.tags.SlimefunTranslationTag;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;

public final class ConfigUtils {
    @Nonnull
    public static <V> Map<String, V> getMap(@Nullable ConfigurationSection section) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (section == null) {
            return map;
        }
        for (String key : section.getKeys(false)) {
            Object value = section.get(key);
            if (!(value instanceof String) && !(value instanceof Integer) && !(value instanceof Double) && !(value instanceof Boolean)) continue;
            map.put(key, value);
        }
        return map;
    }

    @Nonnull
    public static Set<Material> parseMaterials(@Nonnull List<String> materialList) {
        Preconditions.checkArgument((materialList != null ? 1 : 0) != 0, (Object)"materialList cannot be null");
        HashSet<Material> materials = new HashSet<Material>();
        for (String value : materialList) {
            try {
                if (Patterns.MINECRAFT_NAMESPACEDKEY.matcher(value).matches()) {
                    Material material = Material.matchMaterial((String)value);
                    if (material != null) {
                        materials.add(material);
                        continue;
                    }
                    throw new InvalidConfigurationException("Invalid minecraft material: " + value);
                }
                if (!Patterns.SFT_TAG_CONFIG.matcher(value).matches()) continue;
                String keyValue = CommonPatterns.COLON.split(value)[1].toUpperCase(Locale.ROOT);
                SlimefunTranslationTag tag = SlimefunTranslationTag.getTag(keyValue);
                if (tag != null) {
                    materials.addAll(tag.getValues());
                    continue;
                }
                throw new InvalidConfigurationException("Invalid SlimefunTranslationTag: " + keyValue);
            }
            catch (InvalidConfigurationException ex) {
                SlimefunTranslation.log(Level.SEVERE, ex.getMessage(), new Object[]{ex});
            }
        }
        return materials;
    }

    private ConfigUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

