/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.slimefuntranslation.api.config;

import com.google.common.base.Preconditions;
import io.github.thebusybiscuit.slimefun4.api.SlimefunAddon;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.libraries.dough.collections.Pair;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.guizhanss.slimefuntranslation.SlimefunTranslation;
import net.guizhanss.slimefuntranslation.api.config.TranslationConditions;
import net.guizhanss.slimefuntranslation.api.config.TranslationConfigurationFields;
import net.guizhanss.slimefuntranslation.api.translation.ItemTranslation;
import net.guizhanss.slimefuntranslation.implementation.translations.FixedItemTranslation;
import net.guizhanss.slimefuntranslation.utils.ConfigUtils;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;

public class TranslationConfiguration {
    private final String name;
    private final String lang;
    private final Map<String, ItemTranslation> itemTranslations;
    private final Map<String, String> loreTranslations;
    private final Map<String, String> messageTranslations;
    private State state = State.UNREGISTERED;
    private SlimefunAddon addon = null;

    @Nonnull
    @ParametersAreNonnullByDefault
    public static Optional<TranslationConfiguration> fromFileConfiguration(String language, FileConfiguration config) {
        return TranslationConfiguration.fromFileConfiguration(language, config, TranslationConfigurationFields.DEFAULT);
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public static Optional<TranslationConfiguration> fromFileConfiguration(String language, FileConfiguration config, TranslationConfigurationFields fields) {
        Preconditions.checkArgument((config != null ? 1 : 0) != 0, (Object)"config cannot be null");
        String name = config.getString("name", "Unnamed Translation");
        String lang = SlimefunTranslation.getConfigService().getMappedLanguage(language);
        String prefix = config.getString(fields.getPrefix(), "");
        String suffix = config.getString(fields.getSuffix(), "");
        ConfigurationSection itemsSection = config.getConfigurationSection(fields.getItems());
        ConfigurationSection loreSection = config.getConfigurationSection(fields.getLore());
        ConfigurationSection messagesSection = config.getConfigurationSection(fields.getMessages());
        if (itemsSection == null && loreSection == null && messagesSection == null) {
            SlimefunTranslation.log(Level.WARNING, "No translations found in " + name, new Object[0]);
            return Optional.empty();
        }
        TranslationConditions fileConditions = TranslationConditions.load(config.getConfigurationSection(fields.getConditions()));
        SlimefunTranslation.debug("Current file condition: {0}", fileConditions);
        HashMap<String, ItemTranslation> itemTranslations = new HashMap<String, ItemTranslation>();
        HashMap<String, String> loreTranslations = new HashMap<String, String>();
        HashMap<String, String> messageTranslations = new HashMap<String, String>();
        SlimefunTranslation.log(Level.INFO, "Loading translation configuration \"{0}\", language: {1}", name, lang);
        if (itemsSection != null) {
            int count = 0;
            for (String id : itemsSection.getKeys(false)) {
                Map<Object, Pair> replacements;
                String itemId = prefix + id + suffix;
                SlimefunTranslation.debug("Loading item translation {0}", itemId);
                ConfigurationSection itemSection = itemsSection.getConfigurationSection(itemId);
                if (itemSection == null) {
                    SlimefunTranslation.log(Level.SEVERE, "Invalid item {0} in translation {1}", itemId, name);
                    continue;
                }
                TranslationConditions itemConditions = TranslationConditions.load(fileConditions, itemSection.getConfigurationSection(fields.getConditions()));
                SlimefunTranslation.debug("Current item condition: {0}", itemConditions);
                boolean forceLoad = itemConditions.isForceLoad();
                SlimefunItem sfItem = SlimefunItem.getById((String)itemId);
                if (sfItem == null && !forceLoad) {
                    SlimefunTranslation.log(Level.SEVERE, "Invalid item {0}", itemId);
                    continue;
                }
                String displayName = "";
                if (itemSection.contains("name")) {
                    displayName = itemSection.getString("name", "");
                }
                List lore = itemSection.getStringList("lore");
                HashMap<Integer, String> overrides = new HashMap<Integer, String>();
                if (itemSection.contains("lore-overrides")) {
                    try {
                        replacements = ConfigUtils.getMap(itemSection.getConfigurationSection("lore-overrides"));
                        for (Map.Entry entry : replacements.entrySet()) {
                            overrides.put(Integer.parseInt((String)entry.getKey()), (String)entry.getValue());
                        }
                    }
                    catch (NullPointerException | NumberFormatException ex) {
                        SlimefunTranslation.log(Level.SEVERE, "Invalid lore overrides of item {0} in translation {1}", itemId, name);
                        return Optional.empty();
                    }
                }
                replacements = new HashMap();
                if (itemSection.contains("lore-replacements")) {
                    try {
                        for (String idx : itemSection.getConfigurationSection("lore-replacements").getKeys(false)) {
                            int i = Integer.parseInt(idx);
                            ConfigurationSection section = itemSection.getConfigurationSection("lore-replacements." + idx);
                            replacements.put(i, new Pair((Object)section.getString("original"), (Object)section.getString("replaced")));
                        }
                    }
                    catch (NullPointerException | NumberFormatException ex) {
                        SlimefunTranslation.log(Level.SEVERE, "Invalid lore replacements of item {0} in translation {1}", itemId, name);
                        return Optional.empty();
                    }
                }
                if (!itemConditions.isPartialOverride() && !forceLoad) {
                    itemConditions.setPartialOverride(SlimefunTranslation.getConfigService().getPartialOverrideMaterials().contains(sfItem.getItem().getType()));
                }
                FixedItemTranslation translation = new FixedItemTranslation(displayName, lore, overrides, replacements, itemConditions);
                itemTranslations.put(itemId, translation);
                ++count;
            }
            SlimefunTranslation.log(Level.INFO, "Loaded {0} item translations.", count);
        }
        if (loreSection != null) {
            for (String loreId : loreSection.getKeys(true)) {
                SlimefunTranslation.debug("Loading lore translation {0}", loreId);
                String lore = loreSection.getString(loreId);
                loreTranslations.put(loreId, lore);
            }
        }
        if (messagesSection != null) {
            for (String messageId : messagesSection.getKeys(true)) {
                SlimefunTranslation.debug("Loading message translation {0}", messageId);
                String message = messagesSection.getString(messageId);
                messageTranslations.put(messageId, message);
            }
        }
        return Optional.of(new TranslationConfiguration(name, lang, itemTranslations, loreTranslations, messageTranslations));
    }

    public void register(@Nonnull SlimefunAddon addon) {
        if (this.state != State.UNREGISTERED) {
            throw new IllegalStateException("TranslationConfiguration is already registered");
        }
        Map<String, Map<String, ItemTranslation>> allItemTranslations = SlimefunTranslation.getRegistry().getItemTranslations();
        allItemTranslations.putIfAbsent(this.lang, new HashMap());
        Map<String, ItemTranslation> currentTranslations = allItemTranslations.get(this.lang);
        currentTranslations.putAll(this.itemTranslations);
        Map<String, Map<String, String>> allLoreTranslations = SlimefunTranslation.getRegistry().getLoreTranslations();
        allLoreTranslations.putIfAbsent(this.lang, new HashMap());
        Map<String, String> currentLoreTranslations = allLoreTranslations.get(this.lang);
        currentLoreTranslations.putAll(this.loreTranslations);
        Map<String, Map<String, Map<String, String>>> allMessageTranslations = SlimefunTranslation.getRegistry().getMessageTranslations();
        allMessageTranslations.putIfAbsent(addon.getName(), new HashMap());
        Map<String, Map<String, String>> pluginMessageTranslations = allMessageTranslations.get(addon.getName());
        pluginMessageTranslations.putIfAbsent(this.lang, new HashMap());
        Map<String, String> currentMessageTranslations = pluginMessageTranslations.get(this.lang);
        currentMessageTranslations.putAll(this.messageTranslations);
        this.addon = addon;
        this.setState(State.REGISTERED);
    }

    public TranslationConfiguration(String name, String lang, Map<String, ItemTranslation> itemTranslations, Map<String, String> loreTranslations, Map<String, String> messageTranslations) {
        this.name = name;
        this.lang = lang;
        this.itemTranslations = itemTranslations;
        this.loreTranslations = loreTranslations;
        this.messageTranslations = messageTranslations;
    }

    public String getName() {
        return this.name;
    }

    public String getLang() {
        return this.lang;
    }

    public Map<String, ItemTranslation> getItemTranslations() {
        return this.itemTranslations;
    }

    public Map<String, String> getLoreTranslations() {
        return this.loreTranslations;
    }

    public Map<String, String> getMessageTranslations() {
        return this.messageTranslations;
    }

    public State getState() {
        return this.state;
    }

    public SlimefunAddon getAddon() {
        return this.addon;
    }

    protected void setState(State state) {
        this.state = state;
    }

    protected void setAddon(SlimefunAddon addon) {
        this.addon = addon;
    }

    public static enum State {
        UNREGISTERED,
        REGISTERED;

    }
}

