/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.slimefuntranslation;

import com.google.common.base.Preconditions;
import io.github.thebusybiscuit.slimefun4.libraries.dough.updater.BlobBuildUpdater;
import java.io.File;
import java.lang.reflect.Method;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import net.guizhanss.slimefuntranslation.core.Registry;
import net.guizhanss.slimefuntranslation.core.services.CommandService;
import net.guizhanss.slimefuntranslation.core.services.ConfigurationService;
import net.guizhanss.slimefuntranslation.core.services.IntegrationService;
import net.guizhanss.slimefuntranslation.core.services.ListenerService;
import net.guizhanss.slimefuntranslation.core.services.TranslationService;
import net.guizhanss.slimefuntranslation.core.services.UserService;
import net.guizhanss.slimefuntranslation.libs.bstats.bukkit.Metrics;
import net.guizhanss.slimefuntranslation.libs.guizhanlib.slimefun.addon.AbstractAddon;
import net.guizhanss.slimefuntranslation.libs.guizhanlib.updater.GuizhanBuildsUpdater;
import net.guizhanss.slimefuntranslation.utils.tags.SlimefunTranslationTag;
import org.bukkit.plugin.Plugin;

public final class SlimefunTranslation
extends AbstractAddon {
    private ConfigurationService configService;
    private Registry registry;
    private UserService userService;
    private TranslationService translationService;
    private IntegrationService integrationService;
    private boolean debugEnabled = false;

    public SlimefunTranslation() {
        super("ybw0014", "SlimefunTranslation", "master", "auto-update");
    }

    private static SlimefunTranslation inst() {
        return (SlimefunTranslation)((Object)SlimefunTranslation.getInstance());
    }

    @Nonnull
    public static ConfigurationService getConfigService() {
        return SlimefunTranslation.inst().configService;
    }

    @Nonnull
    public static Registry getRegistry() {
        return SlimefunTranslation.inst().registry;
    }

    @Nonnull
    public static UserService getUserService() {
        return SlimefunTranslation.inst().userService;
    }

    @Nonnull
    public static TranslationService getTranslationService() {
        return SlimefunTranslation.inst().translationService;
    }

    @Nonnull
    public static IntegrationService getIntegrationService() {
        return SlimefunTranslation.inst().integrationService;
    }

    public static void debug(@Nonnull String message, Object ... args) {
        Preconditions.checkNotNull((Object)message, (Object)"message cannot be null");
        if (SlimefunTranslation.inst().debugEnabled) {
            SlimefunTranslation.inst().getLogger().log(Level.INFO, "[DEBUG] " + message, args);
        }
    }

    @Override
    public void enable() {
        SlimefunTranslation.log(Level.INFO, "====================", new Object[0]);
        SlimefunTranslation.log(Level.INFO, "Slimefun Translation", new Object[0]);
        SlimefunTranslation.log(Level.INFO, "     by ybw0014     ", new Object[0]);
        SlimefunTranslation.log(Level.INFO, "====================", new Object[0]);
        SlimefunTranslationTag.reloadAll();
        this.configService = new ConfigurationService(this);
        this.registry = new Registry();
        this.debugEnabled = this.configService.isDebug();
        this.userService = new UserService();
        this.translationService = new TranslationService(this, this.getFile());
        new CommandService(this);
        new ListenerService(this);
        this.integrationService = new IntegrationService(this);
        this.setupMetrics();
    }

    @Override
    public void disable() {
    }

    private void setupMetrics() {
        new Metrics(this, 20496);
    }

    @Override
    protected void autoUpdate() {
        if (this.getPluginVersion().startsWith("Dev")) {
            new BlobBuildUpdater((Plugin)this, this.getFile(), this.getGithubRepo()).start();
        } else if (this.getPluginVersion().startsWith("Build")) {
            try {
                Class<?> clazz = Class.forName("net.guizhanss.slimefuntranslation.libs.guizhanlibplugin.updater.GuizhanUpdater");
                Method updaterStart = clazz.getDeclaredMethod("start", Plugin.class, File.class, String.class, String.class, String.class);
                updaterStart.invoke(null, new Object[]{this, this.getFile(), this.getGithubUser(), this.getGithubRepo(), this.getGithubBranch()});
            }
            catch (Exception ignored) {
                new GuizhanBuildsUpdater((Plugin)this, this.getFile(), this.getGithubUser(), this.getGithubRepo(), this.getGithubBranch()).start();
            }
        }
    }
}

