/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.slimefuntranslation.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.guizhanss.slimefuntranslation.SlimefunTranslation;

public final class FileUtils {
    @Nonnull
    public static List<String> listFolders(@Nonnull File folder) {
        if (folder == null || !folder.isDirectory()) {
            return Collections.emptyList();
        }
        File[] files = folder.listFiles();
        if (files == null) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        for (File file : files) {
            if (!file.isDirectory()) continue;
            result.add(file.getName());
        }
        return result;
    }

    @Nonnull
    public static List<String> listYamlFiles(@Nonnull File folder) {
        return FileUtils.listYamlFiles(folder, "");
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    private static List<String> listYamlFiles(File folder, String path) {
        if (folder == null || !folder.isDirectory()) {
            return Collections.emptyList();
        }
        File[] files = folder.listFiles();
        if (files == null) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        for (File file : files) {
            String filename = file.getName();
            if (filename.startsWith(".") || filename.startsWith("_")) continue;
            if (file.isDirectory()) {
                String subFolderPath = path + filename + File.separator;
                result.addAll(FileUtils.listYamlFiles(file, subFolderPath));
                continue;
            }
            if (!filename.endsWith(".yml") && !filename.endsWith(".yaml")) continue;
            result.add(path + filename);
        }
        return result;
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public static List<String> listYamlFilesInJar(File jarFile, String folderPath) {
        if (jarFile == null || !jarFile.isFile()) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        try (JarInputStream stream = new JarInputStream(new FileInputStream(jarFile));){
            JarEntry entry;
            while ((entry = stream.getNextJarEntry()) != null) {
                String entryName = entry.getName();
                String filename = entryName.substring(entryName.lastIndexOf("/") + 1);
                if (!entryName.startsWith(folderPath) || !filename.endsWith(".yml") || entry.isDirectory()) continue;
                result.add(entryName.replace(folderPath, ""));
            }
        }
        catch (IOException ex) {
            SlimefunTranslation.log(Level.SEVERE, ex, "An error has occurred while listing YAML files in jar file {0}", jarFile.getName());
        }
        return result;
    }

    private FileUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

