/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.slimefuntranslation.implementation.translations;

import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.libraries.dough.collections.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.guizhanss.slimefuntranslation.api.config.TranslationConditions;
import net.guizhanss.slimefuntranslation.api.translation.ItemTranslation;
import net.guizhanss.slimefuntranslation.api.translation.TranslationStatus;
import net.guizhanss.slimefuntranslation.core.users.User;
import net.guizhanss.slimefuntranslation.utils.ColorUtils;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class FixedItemTranslation
implements ItemTranslation {
    private final String displayName;
    private final List<String> lore;
    private final Map<Integer, String> overrides;
    private final Map<Integer, Pair<String, String>> replacements;
    private final TranslationConditions conditions;

    public FixedItemTranslation(String displayName, List<String> lore) {
        this(displayName, lore, Map.of(), Map.of(), new TranslationConditions());
    }

    @ParametersAreNonnullByDefault
    public FixedItemTranslation(String displayName, List<String> lore, Map<Integer, String> overrides, Map<Integer, Pair<String, String>> replacements, TranslationConditions conditions) {
        this.displayName = ColorUtils.color(displayName);
        this.lore = ColorUtils.color(lore);
        this.overrides = overrides;
        this.replacements = replacements;
        this.conditions = conditions;
    }

    @Override
    @Nonnull
    @ParametersAreNonnullByDefault
    public String getDisplayName(User user, ItemStack item, ItemMeta meta, String original) {
        return this.displayName.isEmpty() ? original : this.displayName;
    }

    @Override
    @Nonnull
    @ParametersAreNonnullByDefault
    public List<String> getLore(User user, ItemStack item, ItemMeta meta, List<String> original) {
        ArrayList<String> newLore = new ArrayList<String>(original);
        if (!this.lore.isEmpty()) {
            if (this.conditions.isPartialOverride()) {
                for (int i = 0; i < this.lore.size(); ++i) {
                    try {
                        String string = this.lore.get(i);
                        newLore.set(i, ColorUtils.color(string));
                        continue;
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        // empty catch block
                    }
                }
            } else {
                newLore = new ArrayList<String>(this.lore);
            }
        }
        for (Map.Entry<Integer, String> entry : this.overrides.entrySet()) {
            try {
                newLore.set(entry.getKey() - 1, ColorUtils.color(entry.getValue()));
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        }
        for (Map.Entry<Integer, String> entry : this.replacements.entrySet()) {
            try {
                String line = (String)newLore.get(entry.getKey() - 1);
                newLore.set(entry.getKey() - 1, ColorUtils.color(line.replace((CharSequence)((Pair)entry.getValue()).getFirstValue(), (CharSequence)((Pair)entry.getValue()).getSecondValue())));
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        }
        return newLore;
    }

    @Override
    @Nonnull
    @ParametersAreNonnullByDefault
    public TranslationStatus canTranslate(User user, ItemStack item, ItemMeta meta, String sfId) {
        if (this.conditions.isForceLoad()) {
            return TranslationStatus.ALLOWED;
        }
        SlimefunItem sfItem = SlimefunItem.getById((String)sfId);
        if (sfItem == null) {
            return TranslationStatus.DENIED;
        }
        if (this.conditions.isMatchName()) {
            String originalDisplayName = sfItem.getItemName();
            if (!meta.hasDisplayName() || !meta.getDisplayName().equals(originalDisplayName)) {
                return TranslationStatus.DENIED;
            }
        }
        if (meta.hasLore()) {
            ItemStack originalItem = sfItem.getItem();
            if (originalItem instanceof SlimefunItemStack) {
                SlimefunItemStack sfItemStack = (SlimefunItemStack)originalItem;
                Optional originalLore = sfItemStack.getItemMetaSnapshot().getLore();
                if (originalLore.isEmpty() || !meta.getLore().equals(originalLore.get())) {
                    return TranslationStatus.NAME_ONLY;
                }
            } else {
                ItemMeta originalMeta = originalItem.getItemMeta();
                if (!originalMeta.hasLore()) {
                    return TranslationStatus.DENIED;
                }
                List originalLore = originalMeta.getLore();
                if (!meta.getLore().equals(originalLore)) {
                    return TranslationStatus.NAME_ONLY;
                }
            }
        }
        return TranslationStatus.ALLOWED;
    }
}

