/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.slimefuntranslation.core.services;

import com.google.common.base.Preconditions;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.guizhanss.slimefuntranslation.SlimefunTranslation;
import net.guizhanss.slimefuntranslation.libs.guizhanlib.slimefun.addon.AddonConfig;
import net.guizhanss.slimefuntranslation.utils.ConfigUtils;
import org.bukkit.Material;

public final class ConfigurationService {
    private final AddonConfig config;
    private boolean autoUpdate;
    private boolean debug;
    private Map<String, String> languageMappings;
    private Set<String> disabledLanguages;
    private Set<Material> partialOverrideMaterials;
    private Set<String> disabledItems;

    public ConfigurationService(SlimefunTranslation plugin) {
        this.config = new AddonConfig(plugin, "config.yml");
        this.reload();
    }

    public void reload() {
        this.config.reload();
        this.config.addMissingKeys();
        this.autoUpdate = this.config.getBoolean("auto-update", true);
        this.debug = this.config.getBoolean("debug", false);
        this.languageMappings = ConfigUtils.getMap(this.config.getConfigurationSection("language-mappings"));
        this.disabledLanguages = new HashSet<String>(this.config.getStringList("disabled-languages"));
        this.partialOverrideMaterials = ConfigUtils.parseMaterials(this.config.getStringList("partial-override-materials"));
        this.disabledItems = new HashSet<String>(this.config.getStringList("disabled-items"));
        this.config.save();
    }

    @Nonnull
    public String getMappedLanguage(@Nonnull String language) {
        Preconditions.checkArgument((language != null ? 1 : 0) != 0, (Object)"language cannot be null");
        return SlimefunTranslation.getConfigService().getLanguageMappings().getOrDefault(language, language);
    }

    public boolean isAutoUpdate() {
        return this.autoUpdate;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public Map<String, String> getLanguageMappings() {
        return this.languageMappings;
    }

    public Set<String> getDisabledLanguages() {
        return this.disabledLanguages;
    }

    public Set<Material> getPartialOverrideMaterials() {
        return this.partialOverrideMaterials;
    }

    public Set<String> getDisabledItems() {
        return this.disabledItems;
    }
}

