/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.slimefuntranslation.api;

import com.google.common.base.Preconditions;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.guizhanss.slimefuntranslation.SlimefunTranslation;
import net.guizhanss.slimefuntranslation.api.translation.lore.LoreHandler;
import net.guizhanss.slimefuntranslation.core.factories.MessageFactory;
import net.guizhanss.slimefuntranslation.core.users.User;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public final class SlimefunTranslationAPI {
    @Nonnull
    public static User getUser(@Nonnull UUID uuid) {
        Preconditions.checkArgument((uuid != null ? 1 : 0) != 0, (Object)"UUID cannot be null");
        return SlimefunTranslation.getUserService().getUser(uuid);
    }

    @Nonnull
    public static User getUser(@Nonnull Player player) {
        Preconditions.checkArgument((player != null ? 1 : 0) != 0, (Object)"Player cannot be null");
        return SlimefunTranslationAPI.getUser(player.getUniqueId());
    }

    @Nonnull
    public static String getItemName(@Nonnull User user, @Nullable SlimefunItem sfItem) {
        Preconditions.checkArgument((user != null ? 1 : 0) != 0, (Object)"User cannot be null");
        return SlimefunTranslation.getTranslationService().getTranslatedItemName(user, sfItem);
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public static String getItemName(User user, String id) {
        Preconditions.checkArgument((user != null ? 1 : 0) != 0, (Object)"User cannot be null");
        Preconditions.checkArgument((id != null ? 1 : 0) != 0, (Object)"ID cannot be null");
        return SlimefunTranslation.getTranslationService().getTranslatedItemName(user, SlimefunItem.getById((String)id));
    }

    @ParametersAreNonnullByDefault
    public static boolean translateItem(User user, ItemStack item) {
        Preconditions.checkArgument((user != null ? 1 : 0) != 0, (Object)"User cannot be null");
        Preconditions.checkArgument((item != null ? 1 : 0) != 0, (Object)"Item cannot be null");
        return SlimefunTranslation.getTranslationService().translateItem(user, item);
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public static String getLore(User user, String id, boolean defaultToId) {
        Preconditions.checkArgument((user != null ? 1 : 0) != 0, (Object)"User cannot be null");
        Preconditions.checkArgument((id != null ? 1 : 0) != 0, (Object)"ID cannot be null");
        return SlimefunTranslation.getTranslationService().getLore(user, id, defaultToId);
    }

    @ParametersAreNonnullByDefault
    public static void registerLoreHandler(String id, LoreHandler handler) {
        Preconditions.checkArgument((id != null ? 1 : 0) != 0, (Object)"ID cannot be null");
        Preconditions.checkArgument((handler != null ? 1 : 0) != 0, (Object)"Handler cannot be null");
        SlimefunTranslation.getRegistry().getSlimefunLoreHandlers().put(id, handler);
    }

    @Nonnull
    public static MessageFactory getMessageFactory(@Nonnull Plugin plugin) {
        Preconditions.checkArgument((plugin != null ? 1 : 0) != 0, (Object)"Plugin cannot be null");
        return MessageFactory.get(plugin);
    }

    private SlimefunTranslationAPI() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

