/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.slimefuntranslation.integrations.placeholders;

import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.guizhanss.slimefuntranslation.SlimefunTranslation;
import net.guizhanss.slimefuntranslation.api.SlimefunTranslationAPI;
import net.guizhanss.slimefuntranslation.api.translation.lore.LoreHandler;
import net.guizhanss.slimefuntranslation.core.users.User;
import net.guizhanss.slimefuntranslation.integrations.placeholders.AExpansion;
import org.bukkit.entity.Player;

public class SlimefunLoreExpansion
extends AExpansion {
    public SlimefunLoreExpansion() {
        SlimefunTranslationAPI.registerLoreHandler("Machine", (user, id, args) -> {
            if (args.length != 2) {
                return null;
            }
            return this.getLore(user, "Machine.Format", this.getLore(user, "Machine.TierColor." + args[0], new String[0]), this.getLore(user, "Machine.Tier." + args[0], new String[0]), this.getLore(user, "Machine.Type." + args[1], new String[0]));
        });
        SlimefunTranslationAPI.registerLoreHandler("Radioactive", (user, id, args) -> {
            if (args.length != 1) {
                return null;
            }
            return this.getLore(user, "Radioactive", this.getLore(user, "Radioactivity." + args[0], new String[0]));
        });
        SlimefunTranslationAPI.registerLoreHandler("Material", (user, id, args) -> {
            if (args.length != 1) {
                return null;
            }
            return this.getLore(user, "Material", this.getLore(user, "Materials." + args[0], new String[0]));
        });
    }

    @Nonnull
    public String getName() {
        return "SlimefunLore";
    }

    @Nonnull
    public String getIdentifier() {
        return "sftrlore";
    }

    @Nullable
    @ParametersAreNonnullByDefault
    public String onPlaceholderRequest(Player p, String identifier) {
        User user = SlimefunTranslation.getUserService().getUser(p.getUniqueId());
        String[] s = identifier.split("_");
        String id = s[0];
        String[] args = new String[]{};
        if (s.length >= 2) {
            args = Arrays.copyOfRange(s, 1, s.length);
        }
        LoreHandler handler = SlimefunTranslation.getRegistry().getSlimefunLoreHandlers().getOrDefault(id, this::getLore);
        return handler.getLore(user, id, args);
    }
}

