/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.slimefuntranslation.implementation.packetlisteners.server;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import com.comphenix.protocol.wrappers.WrappedDataValue;
import com.comphenix.protocol.wrappers.WrappedDataWatcher;
import com.comphenix.protocol.wrappers.WrappedWatchableObject;
import io.github.thebusybiscuit.slimefun4.api.MinecraftVersion;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.paperlib.PaperLib;
import java.util.ArrayList;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.guizhanss.slimefuntranslation.SlimefunTranslation;
import net.guizhanss.slimefuntranslation.core.users.User;
import net.guizhanss.slimefuntranslation.implementation.packetlisteners.server.AServerListener;
import net.guizhanss.slimefuntranslation.utils.SlimefunItemUtils;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Item;
import org.bukkit.inventory.ItemStack;

public class EntityMetadataListener
extends AServerListener {
    private static final boolean USE_DV = Slimefun.getMinecraftVersion().isAtLeast(MinecraftVersion.MINECRAFT_1_20) || Slimefun.getMinecraftVersion().isAtLeast(MinecraftVersion.MINECRAFT_1_19) && PaperLib.getMinecraftPatchVersion() >= 3;

    public EntityMetadataListener() {
        super(PacketType.Play.Server.ENTITY_METADATA);
    }

    @Override
    protected void process(@Nonnull PacketEvent event) {
        User user = this.getUser(event);
        if (user == null) {
            return;
        }
        PacketContainer packet = event.getPacket();
        Entity entity = (Entity)packet.getEntityModifier(event).read(0);
        if (entity == null || entity.getType() != EntityType.DROPPED_ITEM) {
            return;
        }
        Item itemEntity = (Item)entity;
        if (!entity.isCustomNameVisible()) {
            return;
        }
        ItemStack item = itemEntity.getItemStack();
        String sfId = SlimefunItemUtils.getId(item);
        if (sfId == null) {
            return;
        }
        PacketContainer processed = this.processPacket(packet, user, itemEntity, sfId);
        event.setPacket(processed);
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    private PacketContainer processPacket(PacketContainer packet, User user, Item item, String sfId) {
        WrappedDataWatcher dataWatcher = WrappedDataWatcher.getEntityWatcher((Entity)item).deepClone();
        WrappedDataWatcher.WrappedDataWatcherObject optChatFieldWatcher = new WrappedDataWatcher.WrappedDataWatcherObject(2, WrappedDataWatcher.Registry.getChatComponentSerializer((boolean)true));
        Optional<Object> optChatField = Optional.of(WrappedChatComponent.fromChatMessage((String)SlimefunTranslation.getTranslationService().getTranslatedItemName(user, SlimefunItem.getById((String)sfId)))[0].getHandle());
        dataWatcher.setObject(optChatFieldWatcher, optChatField);
        if (USE_DV) {
            ArrayList<WrappedDataValue> wrappedDataValueList = new ArrayList<WrappedDataValue>();
            for (WrappedWatchableObject entry : dataWatcher.getWatchableObjects()) {
                if (entry == null) continue;
                WrappedDataWatcher.WrappedDataWatcherObject watcherObject = entry.getWatcherObject();
                wrappedDataValueList.add(new WrappedDataValue(watcherObject.getIndex(), watcherObject.getSerializer(), entry.getRawValue()));
            }
            packet.getDataValueCollectionModifier().write(0, wrappedDataValueList);
        } else {
            packet.getWatchableCollectionModifier().write(0, (Object)dataWatcher.getWatchableObjects());
        }
        return packet;
    }
}

