/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.slimefuntranslation.implementation.packetlisteners;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.events.PacketListener;
import com.google.common.base.Preconditions;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.guizhanss.slimefuntranslation.SlimefunTranslation;
import net.guizhanss.slimefuntranslation.core.users.User;
import org.bukkit.entity.Player;

public abstract class AListener {
    protected final PacketType packetType;
    protected PacketAdapter adapter;

    protected AListener(@Nonnull PacketType packetType) {
        this.packetType = packetType;
    }

    @Nullable
    public User getUser(@Nonnull PacketEvent event) {
        Preconditions.checkArgument((event != null ? 1 : 0) != 0, (Object)"PacketEvent cannot be null");
        Player p = event.getPlayer();
        if (event.isPlayerTemporary()) {
            SlimefunTranslation.log(Level.WARNING, "ProtocolLib returns temporary player [{0}] for packet {1}. It cannot be processed.", p.getAddress(), this.packetType.name());
            return null;
        }
        return SlimefunTranslation.getUserService().getUser(p);
    }

    public void register() {
        ProtocolLibrary.getProtocolManager().addPacketListener((PacketListener)this.adapter);
    }

    protected abstract void process(@Nonnull PacketEvent var1);
}

