/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.slimefuntranslation.core.commands.subcommands;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.player.PlayerProfile;
import io.github.thebusybiscuit.slimefun4.core.guide.SlimefunGuide;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.data.persistent.PersistentDataAPI;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import io.github.thebusybiscuit.slimefun4.utils.ChatUtils;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import java.util.Arrays;
import java.util.Locale;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import net.guizhanss.slimefuntranslation.SlimefunTranslation;
import net.guizhanss.slimefuntranslation.core.commands.AbstractSubCommand;
import net.guizhanss.slimefuntranslation.libs.guizhanlib.minecraft.commands.AbstractCommand;
import net.guizhanss.slimefuntranslation.libs.guizhanlib.minecraft.commands.SubCommand;
import net.guizhanss.slimefuntranslation.utils.constant.Keys;
import net.guizhanss.slimefuntranslation.utils.constant.Permissions;
import org.bukkit.ChatColor;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataHolder;

public class SearchCommand
extends AbstractSubCommand {
    public SearchCommand(@Nonnull AbstractCommand parent) {
        super(parent, "search", (AbstractCommand cmd, CommandSender sender) -> SearchCommand.getDescription("search", sender), "<query> [.] [.] [.] [.] [.]", new SubCommand[0]);
    }

    @Override
    @ParametersAreNonnullByDefault
    public void onExecute(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            MESSAGE_FACTORY.sendMessage(sender, "player-only", new Object[0]);
            return;
        }
        Player p = (Player)sender;
        if (!Permissions.COMMAND_SEARCH.hasPermission((CommandSender)p)) {
            MESSAGE_FACTORY.sendMessage(sender, "no-permission", new Object[0]);
            return;
        }
        String query = String.join((CharSequence)" ", args);
        PlayerProfile.get((OfflinePlayer)p, profile -> this.openSearch((PlayerProfile)profile, query));
    }

    private void openSearch(PlayerProfile profile, String query) {
        Player p = profile.getPlayer();
        if (p == null) {
            return;
        }
        String searchTerm = ChatColor.stripColor((String)query.toLowerCase(Locale.ROOT));
        ChestMenu menu = new ChestMenu(Slimefun.getLocalization().getMessage(p, "guide.search.inventory").replace("%item%", ChatUtils.crop((ChatColor)ChatColor.WHITE, (String)query)));
        menu.setEmptySlotsClickable(false);
        profile.getGuideHistory().add(searchTerm);
        int index = 0;
        for (SlimefunItem slimefunItem : Slimefun.getRegistry().getEnabledSlimefunItems()) {
            if (index == 44) break;
            if (slimefunItem.isHidden() || !slimefunItem.getItemGroup().isAccessible(p) || !this.isSearchFilterApplicable(p, slimefunItem, searchTerm)) continue;
            CustomItemStack itemstack = new CustomItemStack(slimefunItem.getItem(), meta -> {
                ItemGroup itemGroup = slimefunItem.getItemGroup();
                meta.setLore(Arrays.asList("", ChatColor.DARK_GRAY + "\u21e8 " + ChatColor.WHITE + itemGroup.getDisplayName(p)));
                meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES, ItemFlag.HIDE_ENCHANTS, ItemFlag.HIDE_POTION_EFFECTS});
                PersistentDataAPI.setBoolean((PersistentDataHolder)meta, (NamespacedKey)Keys.SEARCH_DISPLAY, (boolean)true);
            });
            menu.addItem(index, (ItemStack)itemstack);
            menu.addMenuClickHandler(index, (pl, slot, itm, action) -> {
                try {
                    SlimefunGuide.displayItem((PlayerProfile)profile, (SlimefunItem)slimefunItem, (boolean)true);
                }
                catch (Exception | LinkageError x) {
                    MESSAGE_FACTORY.sendMessage((CommandSender)pl, "sftranslation.commands.search.error", new Object[0]);
                    SlimefunTranslation.log(Level.WARNING, x, "Failed to open guide for item" + slimefunItem.getId(), new Object[0]);
                }
                return false;
            });
            ++index;
        }
        for (int i = 45; i < 54; ++i) {
            menu.addItem(i, ChestMenuUtils.getBackground(), ChestMenuUtils.getEmptyClickHandler());
        }
        menu.open(new Player[]{p});
    }

    @ParametersAreNonnullByDefault
    private boolean isSearchFilterApplicable(Player p, SlimefunItem slimefunItem, String query) {
        String originalItemName = SlimefunTranslation.getTranslationService().getTranslatedItemName(SlimefunTranslation.getUserService().getUser(p), slimefunItem);
        String itemName = ChatColor.stripColor((String)originalItemName).toLowerCase(Locale.ROOT);
        return !itemName.isEmpty() && itemName.contains(query);
    }
}

