/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.slimefuntranslation.core.commands.subcommands;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.guizhanss.slimefuntranslation.core.commands.AbstractSubCommand;
import net.guizhanss.slimefuntranslation.libs.guizhanlib.minecraft.commands.AbstractCommand;
import net.guizhanss.slimefuntranslation.libs.guizhanlib.minecraft.commands.SubCommand;
import net.guizhanss.slimefuntranslation.utils.SlimefunItemUtils;
import net.guizhanss.slimefuntranslation.utils.constant.Permissions;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.chat.hover.content.Content;
import net.md_5.bungee.api.chat.hover.content.Text;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class IdCommand
extends AbstractSubCommand {
    public IdCommand(@Nonnull AbstractCommand parent) {
        super(parent, "id", (AbstractCommand cmd, CommandSender sender) -> IdCommand.getDescription("id", sender), "", new SubCommand[0]);
    }

    @Override
    @ParametersAreNonnullByDefault
    public void onExecute(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            MESSAGE_FACTORY.sendMessage(sender, "player-only", new Object[0]);
            return;
        }
        Player p = (Player)sender;
        if (!Permissions.COMMAND_ID.hasPermission((CommandSender)p)) {
            MESSAGE_FACTORY.sendMessage(sender, "no-permission", new Object[0]);
            return;
        }
        ItemStack item = p.getInventory().getItemInMainHand();
        if (item.getType().isAir()) {
            MESSAGE_FACTORY.sendMessage(sender, "commands.id.not-sf-item", new Object[0]);
            return;
        }
        String sfId = SlimefunItemUtils.getId(item);
        if (sfId == null) {
            MESSAGE_FACTORY.sendMessage(sender, "commands.id.not-sf-item", new Object[0]);
            return;
        }
        TextComponent msg = new TextComponent(MESSAGE_FACTORY.getMessage(sender, "commands.id.result", new Object[0]));
        msg.setColor(ChatColor.YELLOW);
        String clickToCopy = MESSAGE_FACTORY.getMessage(sender, "commands.id.click-to-copy", new Object[0]);
        TextComponent idMsg = new TextComponent(sfId);
        idMsg.setUnderlined(Boolean.valueOf(true));
        idMsg.setItalic(Boolean.valueOf(true));
        idMsg.setColor(ChatColor.GRAY);
        idMsg.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new Content[]{new Text(clickToCopy)}));
        idMsg.setClickEvent(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, sfId));
        sender.spigot().sendMessage(new BaseComponent[]{msg, idMsg});
    }
}

