/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.sftimeit.util;

import com.google.common.base.Preconditions;
import io.github.thebusybiscuit.slimefun4.libraries.dough.common.ChatColors;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

@ApiStatus.Experimental
public class CustomItemStack
implements Cloneable {
    @NotNull
    private final ItemStack delegate;

    public CustomItemStack(@NotNull ItemStack item) {
        this.delegate = item.clone();
    }

    public CustomItemStack(@NotNull Material material) {
        this.delegate = new ItemStack(material);
    }

    public CustomItemStack(@NotNull ItemStack itemStack, @NotNull Consumer<ItemMeta> itemMetaConsumer) {
        this.delegate = itemStack.clone();
        Preconditions.checkNotNull(itemMetaConsumer, (Object)"ItemMeta consumer cannot be null");
        this.editItemMeta(itemMetaConsumer);
    }

    public CustomItemStack(@NotNull Material material, @NotNull Consumer<ItemMeta> meta) {
        this(new ItemStack(material), meta);
    }

    public CustomItemStack(@NotNull ItemStack itemStack, @Nullable String name, @NotNull List<String> lore) {
        this(itemStack, name, lore.toArray(new String[0]));
    }

    public CustomItemStack(@NotNull ItemStack itemStack, @Nullable String name, String ... lore) {
        this(itemStack, (ItemMeta itemMeta) -> {
            if (name != null) {
                itemMeta.setDisplayName(CustomItemStack.color(name));
            }
            if (lore.length > 0) {
                ArrayList<String> lines = new ArrayList<String>();
                for (String line : lore) {
                    lines.add(CustomItemStack.color(line));
                }
                itemMeta.setLore(lines);
            }
        });
    }

    public CustomItemStack(@NotNull ItemStack itemStack, Color color, @Nullable String name, String ... lore) {
        this(itemStack, (ItemMeta itemMeta) -> {
            if (name != null) {
                itemMeta.setDisplayName(CustomItemStack.color(name));
            }
            if (lore.length > 0) {
                ArrayList<String> lines = new ArrayList<String>();
                for (String line : lore) {
                    lines.add(CustomItemStack.color(line));
                }
                itemMeta.setLore(lines);
            }
            if (itemMeta instanceof LeatherArmorMeta) {
                LeatherArmorMeta leatherArmorMeta = (LeatherArmorMeta)itemMeta;
                leatherArmorMeta.setColor(color);
            }
            if (itemMeta instanceof PotionMeta) {
                PotionMeta potionMeta = (PotionMeta)itemMeta;
                potionMeta.setColor(color);
            }
        });
    }

    public CustomItemStack(@NotNull Material material, String name, String ... lore) {
        this(new ItemStack(material), name, lore);
    }

    public CustomItemStack(@NotNull Material material, String name, @NotNull List<String> lore) {
        this(new ItemStack(material), name, lore.toArray(new String[0]));
    }

    public CustomItemStack(@NotNull ItemStack itemStack, @NotNull List<String> list) {
        this(itemStack, list.get(0), list.subList(1, list.size()).toArray(new String[0]));
    }

    public CustomItemStack(@NotNull Material material, @NotNull List<String> list) {
        this(new ItemStack(material), list);
    }

    public CustomItemStack(@NotNull ItemStack itemStack, @Range(from=1L, to=0x7FFFFFFFL) int amount) {
        this.delegate = itemStack.clone();
        this.delegate.setAmount(amount);
    }

    public CustomItemStack(@NotNull ItemStack itemStack, @NotNull Material material) {
        this.delegate = itemStack.clone();
        this.delegate.setType(material);
    }

    @NotNull
    public static String color(@NotNull String raw) {
        return ChatColors.color((String)((String)Preconditions.checkNotNull((Object)raw, (Object)"raw cannot be null")));
    }

    @NotNull
    public ItemStack getDelegate() {
        return this.delegate.clone();
    }

    @NotNull
    public Material getType() {
        return this.delegate.getType();
    }

    public void setType(@NotNull Material material) {
        this.delegate.setType(material);
    }

    public int getAmount() {
        return this.delegate.getAmount();
    }

    public void setAmount(int amount) {
        this.delegate.setAmount(amount);
    }

    public boolean hasItemMeta() {
        return this.delegate.hasItemMeta();
    }

    public ItemMeta getItemMeta() {
        return this.delegate.getItemMeta();
    }

    public boolean setItemMeta(ItemMeta meta) {
        return this.delegate.setItemMeta(meta);
    }

    @NotNull
    public CustomItemStack addFlags(ItemFlag ... flags) {
        Preconditions.checkNotNull((Object)flags, (Object)"flags cannot be null");
        Preconditions.checkArgument((flags.length > 0 ? 1 : 0) != 0, (Object)"flags cannot be empty");
        return this.editItemMeta(meta -> meta.addItemFlags(flags));
    }

    @NotNull
    public ItemStack asBukkit() {
        return this.delegate.clone();
    }

    @NotNull
    public CustomItemStack editItemMeta(@NotNull Consumer<ItemMeta> itemMetaConsumer) {
        Preconditions.checkNotNull(itemMetaConsumer, (Object)"ItemMeta consumer cannot be null");
        ItemMeta meta = this.delegate.getItemMeta();
        if (meta != null) {
            itemMetaConsumer.accept(meta);
            this.delegate.setItemMeta(meta);
        }
        return this;
    }

    @NotNull
    public CustomItemStack editItemStack(@NotNull Consumer<ItemStack> itemStackConsumer) {
        Preconditions.checkNotNull(itemStackConsumer, (Object)"ItemStack consumer cannot be null");
        itemStackConsumer.accept(this.delegate);
        return this;
    }

    @NotNull
    public CustomItemStack setCustomModelData(@Range(from=0L, to=0x7FFFFFFFL) int data) {
        return this.editItemMeta(meta -> meta.setCustomModelData(data == 0 ? null : Integer.valueOf(data)));
    }

    @NotNull
    public CustomItemStack clone() {
        return new CustomItemStack(this.getDelegate());
    }
}

