/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.sftimeit.core;

import com.balugaq.sftimeit.api.BlockSetting;
import com.balugaq.sftimeit.api.DoubleHologramOwner;
import com.balugaq.sftimeit.api.MenuMatrix;
import com.balugaq.sftimeit.api.Pair;
import com.balugaq.sftimeit.core.SlimefunTimeit;
import com.balugaq.sftimeit.util.Converter;
import com.balugaq.sftimeit.util.Icons;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.ItemHandler;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockBreakHandler;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockPlaceHandler;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.common.ChatColors;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.Slimefun.Objects.handlers.BlockTicker;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenuPreset;
import me.mrCookieSlime.Slimefun.api.item_transport.ItemTransportFlow;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class TimeitVisualizer
extends SlimefunItem
implements DoubleHologramOwner {
    public static final String BS_TARGET_FACE = "target-face";
    public static final String BS_NORTH = "north";
    public static final String BS_EAST = "east";
    public static final String BS_SOUTH = "south";
    public static final String BS_WEST = "west";
    public static final String BS_UP = "up";
    public static final String BS_DOWN = "down";
    public static final String DEFAULT_FACE = "down";
    private static final List<Pair<String, String>> FACES = List.of(new Pair<String, String>("N", "north"), new Pair<String, String>("E", "east"), new Pair<String, String>("S", "south"), new Pair<String, String>("W", "west"), new Pair<String, String>("U", "up"), new Pair<String, String>("D", "down"));
    private static final MenuMatrix TEMPLATE = new MenuMatrix("", "BBBBBBBBB", "BBBNBBUBB", "BBWBEBBBB", "BBBSBBDBB", "BBBBBBBBC").addItem("B", ChestMenuUtils.getBackground()).addItem("N", ChestMenuUtils.getBackground()).addItem("W", ChestMenuUtils.getBackground()).addItem("E", ChestMenuUtils.getBackground()).addItem("S", ChestMenuUtils.getBackground()).addItem("U", ChestMenuUtils.getBackground()).addItem("D", ChestMenuUtils.getBackground()).addItem("C", Icons.CLEAR_CACHE);
    private static final Object2BooleanOpenHashMap<Location> FIRST_TICK = new Object2BooleanOpenHashMap();
    private static final double NANO_TO_MILLI = 1000000.0;

    public TimeitVisualizer(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(itemGroup, item, recipeType, recipe);
    }

    private static double round(double value, int places) {
        if (places < 0) {
            return value;
        }
        long factor = (long)Math.pow(10.0, places);
        long tmp = Math.round(value *= (double)factor);
        return (double)tmp / (double)factor;
    }

    private static String toString(double value) {
        return String.format("%.2fms", value);
    }

    public static String[] alignStrings(String a, String b) {
        int lenB;
        int lenA = a.length();
        if (lenA == (lenB = b.length())) {
            return new String[]{a, b};
        }
        int targetLength = Math.max(lenA, lenB);
        String adjustedA = a;
        String adjustedB = b;
        if (lenA < targetLength) {
            adjustedA = TimeitVisualizer.centerString(a, targetLength);
        } else {
            adjustedB = TimeitVisualizer.centerString(b, targetLength);
        }
        return new String[]{adjustedA, adjustedB};
    }

    private static String centerString(String str, int targetLength) {
        int strLength = str.length();
        int totalSpaces = targetLength - strLength;
        int leftSpaces = totalSpaces / 2;
        int rightSpaces = totalSpaces - leftSpaces;
        return " ".repeat(Math.max(0, leftSpaces)) + str + " ".repeat(Math.max(0, rightSpaces));
    }

    private static ItemStack getDisplayIcon(Location target, String face, boolean selected) {
        List<String> additionLore;
        ItemStack stack;
        SlimefunItem sf = BlockStorage.check((Location)target);
        if (sf != null) {
            ItemStack icon = sf.getItem().clone();
            stack = Converter.getItem(icon, "&7Choose machine: " + sf.getItemName(), new String[0]);
            additionLore = icon.getLore();
            if (additionLore == null) {
                additionLore = new ArrayList();
            }
        } else {
            stack = Converter.getItem(Material.BLACK_STAINED_GLASS_PANE, "&7Choose direction: " + TimeitVisualizer.localizeFace(face), new String[0]);
            additionLore = new ArrayList<String>();
        }
        additionLore.add("");
        additionLore.add(ChatColors.color((String)(selected ? "&aSelected" : "&7Click to select")));
        stack.setLore(additionLore);
        return stack;
    }

    private static String localizeFace(String face) {
        return switch (face) {
            case BS_NORTH -> "North";
            case BS_EAST -> "East";
            case BS_SOUTH -> "South";
            case BS_WEST -> "West";
            case BS_UP -> "Up";
            case "down" -> "Down";
            default -> face;
        };
    }

    private static Location relative(Block block, @Nullable String face) {
        return block.getLocation().clone().add(TimeitVisualizer.warp2Vector(face));
    }

    private static Vector warp2Vector(@Nullable String face) {
        return TimeitVisualizer.warp2BlockFace(face).getDirection();
    }

    private static BlockFace warp2BlockFace(@Nullable String face) {
        if (face == null) {
            return TimeitVisualizer.warp2BlockFace("down");
        }
        return switch (face) {
            case BS_NORTH -> BlockFace.NORTH;
            case BS_EAST -> BlockFace.EAST;
            case BS_SOUTH -> BlockFace.SOUTH;
            case BS_WEST -> BlockFace.WEST;
            case BS_UP -> BlockFace.UP;
            case "down" -> BlockFace.DOWN;
            default -> TimeitVisualizer.warp2BlockFace("down");
        };
    }

    private void listen(Block monitor, Location target) {
        SlimefunTimeit.monitor().listen(target, null, (location, timeNanos) -> this.updateHologram(monitor, target, timeNanos));
    }

    private void updateHologram(Block monitor, Location target, long timeNanos) {
        BlockSetting data = SlimefunTimeit.monitor().getData(target);
        if (data.tickedTimes == 0L) {
            this.updateHologram(monitor, ChatColors.color((String)"&a  min &7/&e  avg &7/&c  max &7/&b  cur "), ChatColors.color((String)"&a0.00ms&7/&e0.00ms&7/&c0.00ms&7/&b0.00ms"));
            return;
        }
        Object topText = "";
        Object bottomText = "";
        String[] aligned = TimeitVisualizer.alignStrings("min", TimeitVisualizer.toString(TimeitVisualizer.round((double)data.timingNanosMin / 1000000.0, 2)));
        topText = (String)topText + "&a" + aligned[0] + "&7/";
        bottomText = (String)bottomText + "&a" + aligned[1] + "&7/";
        aligned = TimeitVisualizer.alignStrings("avg", TimeitVisualizer.toString(TimeitVisualizer.round((double)data.timingNanosAverage / 1000000.0, 2)));
        topText = (String)topText + "&e" + aligned[0] + "&7/";
        bottomText = (String)bottomText + "&e" + aligned[1] + "&7/";
        aligned = TimeitVisualizer.alignStrings("max", TimeitVisualizer.toString(TimeitVisualizer.round((double)data.timingNanosMax / 1000000.0, 2)));
        topText = (String)topText + "&c" + aligned[0] + "&7/";
        bottomText = (String)bottomText + "&c" + aligned[1] + "&7/";
        aligned = TimeitVisualizer.alignStrings("cur", TimeitVisualizer.toString(TimeitVisualizer.round((double)timeNanos / 1000000.0, 2)));
        topText = (String)topText + "&b" + aligned[0];
        bottomText = (String)bottomText + "&b" + aligned[1];
        this.updateHologram(monitor, (String)topText, (String)bottomText);
    }

    private void unlisten(Location target) {
        SlimefunTimeit.monitor().unlisten(target);
    }

    public void preRegister() {
        this.addItemHandler(new ItemHandler[]{new BlockTicker(){

            public boolean isSynchronized() {
                return false;
            }

            public void tick(Block monitor, SlimefunItem item, Config data) {
                BlockMenu menu;
                if (!FIRST_TICK.getBoolean((Object)monitor.getLocation())) {
                    TimeitVisualizer.this.listen(monitor, TimeitVisualizer.relative(monitor, data.getString(TimeitVisualizer.BS_TARGET_FACE)));
                }
                if ((menu = BlockStorage.getInventory((Block)monitor)) != null && menu.hasViewer()) {
                    TimeitVisualizer.this.updateMenu(menu, monitor, data);
                }
            }
        }});
        this.addItemHandler(new ItemHandler[]{new BlockPlaceHandler(false){

            public void onPlayerPlace(BlockPlaceEvent event) {
                BlockStorage.addBlockInfo((Block)event.getBlock(), (String)TimeitVisualizer.BS_TARGET_FACE, (String)"down");
            }
        }});
        this.addItemHandler(new ItemHandler[]{new BlockBreakHandler(false, false){

            public void onPlayerBreak(BlockBreakEvent event, ItemStack itemStack, List<ItemStack> list) {
                Block block = event.getBlock();
                TimeitVisualizer.this.unlisten(TimeitVisualizer.relative(block, BlockStorage.getLocationInfo((Location)event.getBlock().getLocation(), (String)TimeitVisualizer.BS_TARGET_FACE)));
                Bukkit.getScheduler().runTaskLater((Plugin)SlimefunTimeit.instance(), () -> TimeitVisualizer.this.removeHologram(block), 10L);
            }
        }});
        new BlockMenuPreset(this.getId(), this.getItemName()){

            public void init() {
                TEMPLATE.build(this);
            }

            public void newInstance(@NotNull BlockMenu menu, @NotNull Block monitor) {
                Config data = BlockStorage.getLocationInfo((Location)monitor.getLocation());
                menu.addMenuOpeningHandler(p -> TimeitVisualizer.this.updateMenu(menu, monitor, data));
                for (Pair<String, String> pair : FACES) {
                    String label = pair.first();
                    String face = pair.second();
                    menu.addItem(TEMPLATE.getChar(label), TimeitVisualizer.getDisplayIcon(TimeitVisualizer.relative(monitor, face), face, face.equals(data.getString(TimeitVisualizer.BS_TARGET_FACE))), (p2, s, i, a) -> {
                        TimeitVisualizer.this.unlisten(TimeitVisualizer.relative(monitor, data.getString(TimeitVisualizer.BS_TARGET_FACE)));
                        BlockStorage.addBlockInfo((Block)monitor, (String)TimeitVisualizer.BS_TARGET_FACE, (String)face);
                        TimeitVisualizer.this.listen(monitor, TimeitVisualizer.relative(monitor, face));
                        TimeitVisualizer.this.updateMenu(menu, monitor, data);
                        return false;
                    });
                }
                menu.addMenuClickHandler(TEMPLATE.getChar("C"), (p, s, i, a) -> {
                    SlimefunTimeit.monitor().removeData(TimeitVisualizer.relative(monitor, data.getString(TimeitVisualizer.BS_TARGET_FACE)));
                    p.sendMessage(ChatColors.color((String)"&aCleared Cache"));
                    return false;
                });
            }

            public boolean canOpen(@NotNull Block block, @NotNull Player player) {
                return player.isOp() || player.hasPermission("slimefun.inventory.bypass") || Slimefun.getPermissionsService().hasPermission((Permissible)player, (SlimefunItem)TimeitVisualizer.this);
            }

            public int[] getSlotsAccessedByItemTransport(ItemTransportFlow itemTransportFlow) {
                return new int[0];
            }
        };
    }

    private void updateMenu(BlockMenu menu, Block monitor, Config data) {
        for (Pair<String, String> pair : FACES) {
            String label = pair.first();
            String face = pair.second();
            menu.addItem(TEMPLATE.getChar(label), TimeitVisualizer.getDisplayIcon(TimeitVisualizer.relative(monitor, face), face, face.equals(data.getString(BS_TARGET_FACE))));
        }
    }

    @Override
    public Vector getHologramOffset(Block block) {
        return new Vector(0.5, 0.9, 0.5);
    }

    static {
        FIRST_TICK.defaultReturnValue(false);
    }
}

