/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.sftimeit.api;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenuPreset;
import org.bukkit.inventory.ItemStack;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class MenuMatrix {
    private final List<String> labels = new ArrayList<String>();
    private final Map<Character, ItemStack> itemStackMap = new HashMap<Character, ItemStack>();
    private final Map<Character, ChestMenu.MenuClickHandler> handlerMap = new HashMap<Character, ChestMenu.MenuClickHandler>();

    public MenuMatrix(String ... lines) {
        for (String line : lines) {
            if (line.isEmpty()) continue;
            this.addLine(line);
        }
    }

    public MenuMatrix addLine(String label) {
        this.labels.add(label);
        return this;
    }

    public MenuMatrix addItem(Character label, ItemStack item, ChestMenu.MenuClickHandler handler) {
        this.itemStackMap.put(label, item);
        this.handlerMap.put(label, handler);
        return this;
    }

    public MenuMatrix addItem(Character label, ItemStack item) {
        return this.addItem(label, item, (p, s, i, a) -> false);
    }

    public MenuMatrix addHandler(Character label, ChestMenu.MenuClickHandler handler) {
        this.handlerMap.put(label, handler);
        return this;
    }

    public MenuMatrix addItem(String label, ItemStack item, ChestMenu.MenuClickHandler handler) {
        return this.addItem(Character.valueOf(label.charAt(0)), item, handler);
    }

    public MenuMatrix addItem(String label, ItemStack item) {
        return this.addItem(Character.valueOf(label.charAt(0)), item, (p, s, i, a) -> false);
    }

    public MenuMatrix addHandler(String label, ChestMenu.MenuClickHandler handler) {
        return this.addHandler(Character.valueOf(label.charAt(0)), handler);
    }

    public void build(BlockMenuPreset preset) {
        int index = 0;
        for (String label : this.labels) {
            for (int j = 0; j < label.length() && index < 54; ++index, ++j) {
                char c = label.charAt(j);
                if (!this.itemStackMap.containsKey(Character.valueOf(c))) continue;
                preset.addItem(index, this.itemStackMap.get(Character.valueOf(c)), this.handlerMap.get(Character.valueOf(c)));
            }
        }
    }

    public int getChar(Character label) {
        for (int i = 0; i < this.labels.size(); ++i) {
            String line = this.labels.get(i);
            for (int j = 0; j < line.length(); ++j) {
                if (line.charAt(j) != label.charValue()) continue;
                return i * 9 + j;
            }
        }
        return -1;
    }

    public int getChar(String label) {
        return this.getChar(Character.valueOf(label.charAt(0)));
    }

    public int[] getChars(Character label) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (int i = 0; i < this.labels.size(); ++i) {
            String line = this.labels.get(i);
            for (int j = 0; j < line.length(); ++j) {
                if (line.charAt(j) != label.charValue()) continue;
                result.add(i * 9 + j);
            }
        }
        int[] array = new int[result.size()];
        for (int i = 0; i < result.size(); ++i) {
            array[i] = (Integer)result.get(i);
        }
        return array;
    }

    public int[] getChars(String label) {
        return this.getChars(Character.valueOf(label.charAt(0)));
    }
}

