/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.sftimeit.core;

import com.balugaq.sftimeit.api.BlockSetting;
import com.balugaq.sftimeit.api.MonitorEndAction;
import com.balugaq.sftimeit.api.MonitorStartAction;
import com.balugaq.sftimeit.api.MonitoringBlockTicker;
import com.balugaq.sftimeit.core.SlimefunTimeit;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.github.thebusybiscuit.slimefun4.api.events.SlimefunBlockBreakEvent;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.lang.reflect.Field;
import java.util.function.Consumer;
import me.mrCookieSlime.Slimefun.Objects.handlers.BlockTicker;
import org.bukkit.Location;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.jetbrains.annotations.Nullable;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class Monitor
implements Listener {
    private final Object2ObjectOpenHashMap<Location, BlockSetting> blockSettings = new Object2ObjectOpenHashMap();

    public static void initialize() {
        try {
            Field tickerField = SlimefunItem.class.getDeclaredField("blockTicker");
            tickerField.setAccessible(true);
            SlimefunTimeit.runTaskLaterAsynchronously(() -> {
                for (SlimefunItem item : Slimefun.getRegistry().getAllSlimefunItems()) {
                    BlockTicker ticker = item.getBlockTicker();
                    if (ticker == null || ticker instanceof MonitoringBlockTicker) continue;
                    try {
                        tickerField.set(item, (Object)MonitoringBlockTicker.warp(ticker));
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                }
            }, 1L);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
    }

    public static void unload() {
        try {
            Field tickerField = SlimefunItem.class.getDeclaredField("blockTicker");
            tickerField.setAccessible(true);
            for (SlimefunItem item : Slimefun.getRegistry().getAllSlimefunItems()) {
                BlockTicker ticker = item.getBlockTicker();
                if (ticker == null || !(ticker instanceof MonitoringBlockTicker)) continue;
                MonitoringBlockTicker mbt = (MonitoringBlockTicker)ticker;
                try {
                    tickerField.set(item, mbt.originTicker());
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
    }

    @EventHandler
    public void onBlockBreak(SlimefunBlockBreakEvent event) {
        this.removeData(event.getBlockBroken().getLocation());
    }

    public void removeData(Location location) {
        this.blockSettings.remove((Object)location);
    }

    public BlockSetting getData(Location location) {
        if (!this.blockSettings.containsKey((Object)location)) {
            this.blockSettings.put((Object)location, (Object)new BlockSetting());
        }
        return (BlockSetting)this.blockSettings.get((Object)location);
    }

    @CanIgnoreReturnValue
    public BlockSetting editData(Location location, Consumer<BlockSetting> consumer) {
        BlockSetting data = this.getData(location);
        consumer.accept(data);
        return data;
    }

    public void onTickStart(Location location) {
        this.editData(location, data -> {
            data.lastTickedAt = System.nanoTime();
            ++data.tickedTimes;
        });
    }

    public void onTickEnd(Location location) {
        this.editData(location, data -> {
            long timeNanos = System.nanoTime() - data.lastTickedAt;
            data.timingNanosMax = Math.max(timeNanos, data.timingNanosMax);
            data.timingNanosMin = Math.min(timeNanos, data.timingNanosMin);
            data.timingNanosAverage = (data.timingNanosAverage * data.tickedTimes + timeNanos) / (data.tickedTimes + 1L);
            data.endAction.onEnd(location, timeNanos);
        });
    }

    public void listen(Location location, @Nullable MonitorStartAction startAction, @Nullable MonitorEndAction endAction) {
        this.editData(location, data -> {
            if (startAction != null) {
                data.startAction = startAction;
            }
            if (endAction != null) {
                data.endAction = endAction;
            }
        });
    }

    public void unlisten(Location location) {
        this.editData(location, data -> {
            data.startAction = l -> {};
            data.endAction = (l, timeNanos) -> {};
        });
    }
}

