/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.slimefuncoreprotect.api.utils;

import java.sql.Timestamp;
import java.time.Instant;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TimeUtil {
    @NotNull
    public static Timestamp now() {
        return Timestamp.from(Instant.now());
    }

    public static String getDelay(@NotNull Timestamp timestamp) {
        double delay = (double)(System.currentTimeMillis() - timestamp.getTime()) / 1000.0;
        if (delay < 60.0) {
            return String.format("%.2fs", delay);
        }
        if (delay < 3600.0) {
            return String.format("%.2fm", delay / 60.0);
        }
        if (delay < 86400.0) {
            return String.format("%.2fh", delay / 3600.0);
        }
        return String.format("%.2fd", delay / 86400.0);
    }

    @Nullable
    public static Timestamp parseTime(@NotNull String timeStr) {
        if (timeStr.endsWith("s")) {
            double seconds = Double.parseDouble(timeStr.replace("s", ""));
            return new Timestamp(System.currentTimeMillis() - (long)(seconds * 1000.0));
        }
        if (timeStr.endsWith("m")) {
            double minutes = Double.parseDouble(timeStr.replace("m", ""));
            return new Timestamp(System.currentTimeMillis() - (long)(minutes * 60.0 * 1000.0));
        }
        if (timeStr.endsWith("h")) {
            double hours = Double.parseDouble(timeStr.replace("h", ""));
            return new Timestamp(System.currentTimeMillis() - (long)(hours * 3600.0 * 1000.0));
        }
        if (timeStr.endsWith("d")) {
            double days = Double.parseDouble(timeStr.replace("d", ""));
            return new Timestamp(System.currentTimeMillis() - (long)(days * 86400.0 * 1000.0));
        }
        return null;
    }

    @Generated
    private TimeUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

