/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.slimefuncoreprotect.api.logs;

import com.balugaq.slimefuncoreprotect.api.enums.DatabaseType;
import com.balugaq.slimefuncoreprotect.api.logs.LogEntry;
import com.balugaq.slimefuncoreprotect.api.logs.SourceManager;
import com.balugaq.slimefuncoreprotect.api.utils.Debug;
import com.balugaq.slimefuncoreprotect.implementation.SlimefunCoreProtect;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import javax.sql.DataSource;
import lombok.Generated;
import org.bukkit.Location;
import org.jetbrains.annotations.NotNull;

public class DatabaseManager {
    private static DataSource dataSource = SourceManager.getDataSource();

    public static void createTable() {
        DatabaseType dbType = SlimefunCoreProtect.getInstance().getConfigManager().getDatabaseType();
        String sql = null;
        if (dbType == DatabaseType.SQLITE) {
            sql = "CREATE TABLE IF NOT EXISTS user_logs (\n    id INTEGER PRIMARY KEY AUTOINCREMENT,\n    user TEXT,\n    time TEXT,\n    action TEXT,\n    location TEXT,\n    slimefun_id TEXT,\n    other_data TEXT,\n    status INTEGER DEFAULT 0\n)\n";
        } else if (dbType == DatabaseType.MYSQL) {
            sql = "CREATE TABLE IF NOT EXISTS user_logs (\n    id INT AUTO_INCREMENT PRIMARY KEY,\n    user VARCHAR(255),\n    time TIMESTAMP,\n    action VARCHAR(255),\n    location VARCHAR(255),\n    slimefun_id VARCHAR(255),\n    other_data TEXT,\n    status INT DEFAULT 0\n)\n";
        } else if (dbType == DatabaseType.POSTGRESQL) {
            sql = "CREATE TABLE IF NOT EXISTS user_logs (\n    id SERIAL PRIMARY KEY,\n    user VARCHAR(255),\n    time TIMESTAMP,\n    action VARCHAR(255),\n    location VARCHAR(255),\n    slimefun_id VARCHAR(255),\n    other_data TEXT,\n    status INT DEFAULT 0\n)\n";
        }
        if (sql == null) {
            Debug.log("Unsupported database type: " + String.valueOf((Object)dbType));
        }
        try (Connection conn = SourceManager.getDataSource().getConnection();
             Statement stmt = conn.createStatement();){
            stmt.execute(sql);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static void insertLog(@NotNull LogEntry logEntry) {
        DatabaseManager.insertLog(logEntry.getPlayer(), logEntry.getTime(), logEntry.getAction(), logEntry.getLocation(), logEntry.getSlimefunId(), logEntry.getOtherData());
    }

    public static void insertLog(String user, Timestamp timestamp, String action, @NotNull Location location, String slimefunId, String otherData) {
        DatabaseType dbType = SlimefunCoreProtect.getInstance().getConfigManager().getDatabaseType();
        String sql = null;
        if (dbType == DatabaseType.SQLITE) {
            sql = "INSERT INTO user_logs (user, time, action, location, slimefun_id, other_data) VALUES (?,?,?,?,?,?)";
        } else if (dbType == DatabaseType.MYSQL || dbType == DatabaseType.POSTGRESQL) {
            sql = "INSERT INTO user_logs (user, time, action, location, slimefun_id, other_data) VALUES (?, ?, ?, ?, ?, ?)";
        }
        if (sql == null) {
            Debug.log("Unsupported database type: " + String.valueOf((Object)dbType));
            return;
        }
        try (Connection conn = SourceManager.getDataSource().getConnection();
             PreparedStatement stmt = conn.prepareStatement(sql);){
            stmt.setString(1, user);
            stmt.setTimestamp(2, timestamp);
            stmt.setString(3, action);
            stmt.setString(4, LogEntry.getStringBlockLocation(location));
            stmt.setString(5, slimefunId);
            stmt.setString(6, otherData);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static void shutdown() {
        SourceManager.shutdown();
    }

    @Generated
    public static DataSource getDataSource() {
        return dataSource;
    }
}

