/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.slimefuncoreprotect.api.logs;

import com.balugaq.slimefuncoreprotect.api.utils.Debug;
import java.sql.Timestamp;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LogEntry {
    private static int BIT_MASK_ROLLBACKED = 1;
    private int id;
    private String player;
    private Timestamp time;
    private String action;
    private Location location;
    private String slimefunId;
    private String otherData;
    private int status;

    @NotNull
    public static String getStringBlockLocation(@Nullable Location location) {
        if (location == null) {
            return "unknown";
        }
        Object string = location.getWorld().getName();
        string = (String)string + ";" + location.getBlockX() + ":" + location.getBlockY() + ":" + location.getBlockZ();
        return string;
    }

    @NotNull
    public static String getStringLocation(@Nullable Location location) {
        if (location == null) {
            return "unknown";
        }
        return location.getWorld().getName() + ";" + location.getX() + ":" + location.getY() + ":" + location.getZ() + ":" + location.getYaw() + ":" + location.getPitch();
    }

    public boolean isRolledBack() {
        return (this.status & BIT_MASK_ROLLBACKED) != 0;
    }

    public void setTime(long time) {
        this.time = new Timestamp(time);
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    public void setLocation(@NotNull String location) {
        String[] loc = location.split(";");
        if (loc.length < 2) {
            return;
        }
        World world = Bukkit.getWorld((String)loc[0]);
        if (world == null) {
            Debug.debug("World not found: " + loc[0]);
            return;
        }
        String[] params = loc[1].split(":");
        if (params.length == 3) {
            this.setLocation(new Location(world, Double.parseDouble(params[0]), Double.parseDouble(params[1]), Double.parseDouble(params[2])));
        } else if (params.length == 5) {
            this.setLocation(new Location(world, Double.parseDouble(params[0]), Double.parseDouble(params[1]), Double.parseDouble(params[2]), Float.parseFloat(params[3]), Float.parseFloat(params[4])));
        }
    }

    @Generated
    public String toString() {
        return "LogEntry(id=" + this.getId() + ", player=" + this.getPlayer() + ", time=" + String.valueOf(this.getTime()) + ", action=" + this.getAction() + ", location=" + String.valueOf(this.getLocation()) + ", slimefunId=" + this.getSlimefunId() + ", otherData=" + this.getOtherData() + ", status=" + this.getStatus() + ")";
    }

    @Generated
    public LogEntry() {
    }

    @Generated
    public int getId() {
        return this.id;
    }

    @Generated
    public String getPlayer() {
        return this.player;
    }

    @Generated
    public Timestamp getTime() {
        return this.time;
    }

    @Generated
    public String getAction() {
        return this.action;
    }

    @Generated
    public Location getLocation() {
        return this.location;
    }

    @Generated
    public String getSlimefunId() {
        return this.slimefunId;
    }

    @Generated
    public String getOtherData() {
        return this.otherData;
    }

    @Generated
    public int getStatus() {
        return this.status;
    }

    @Generated
    public void setId(int id) {
        this.id = id;
    }

    @Generated
    public void setPlayer(String player) {
        this.player = player;
    }

    @Generated
    public void setAction(String action) {
        this.action = action;
    }

    @Generated
    public void setSlimefunId(String slimefunId) {
        this.slimefunId = slimefunId;
    }

    @Generated
    public void setOtherData(String otherData) {
        this.otherData = otherData;
    }

    @Generated
    public void setStatus(int status) {
        this.status = status;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LogEntry)) {
            return false;
        }
        LogEntry other = (LogEntry)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        if (this.getStatus() != other.getStatus()) {
            return false;
        }
        String this$player = this.getPlayer();
        String other$player = other.getPlayer();
        if (this$player == null ? other$player != null : !this$player.equals(other$player)) {
            return false;
        }
        Timestamp this$time = this.getTime();
        Timestamp other$time = other.getTime();
        if (this$time == null ? other$time != null : !((Object)this$time).equals(other$time)) {
            return false;
        }
        String this$action = this.getAction();
        String other$action = other.getAction();
        if (this$action == null ? other$action != null : !this$action.equals(other$action)) {
            return false;
        }
        Location this$location = this.getLocation();
        Location other$location = other.getLocation();
        if (this$location == null ? other$location != null : !this$location.equals(other$location)) {
            return false;
        }
        String this$slimefunId = this.getSlimefunId();
        String other$slimefunId = other.getSlimefunId();
        if (this$slimefunId == null ? other$slimefunId != null : !this$slimefunId.equals(other$slimefunId)) {
            return false;
        }
        String this$otherData = this.getOtherData();
        String other$otherData = other.getOtherData();
        return !(this$otherData == null ? other$otherData != null : !this$otherData.equals(other$otherData));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LogEntry;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getId();
        result = result * 59 + this.getStatus();
        String $player = this.getPlayer();
        result = result * 59 + ($player == null ? 43 : $player.hashCode());
        Timestamp $time = this.getTime();
        result = result * 59 + ($time == null ? 43 : ((Object)$time).hashCode());
        String $action = this.getAction();
        result = result * 59 + ($action == null ? 43 : $action.hashCode());
        Location $location = this.getLocation();
        result = result * 59 + ($location == null ? 43 : $location.hashCode());
        String $slimefunId = this.getSlimefunId();
        result = result * 59 + ($slimefunId == null ? 43 : $slimefunId.hashCode());
        String $otherData = this.getOtherData();
        result = result * 59 + ($otherData == null ? 43 : $otherData.hashCode());
        return result;
    }
}

