/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.slimefuncoreprotect.core.managers;

import com.balugaq.slimefuncoreprotect.api.enums.Action;
import com.balugaq.slimefuncoreprotect.api.logs.LogEntry;
import com.balugaq.slimefuncoreprotect.api.utils.Debug;
import com.balugaq.slimefuncoreprotect.api.utils.Lang;
import com.balugaq.slimefuncoreprotect.api.utils.TimeUtil;
import com.balugaq.slimefuncoreprotect.core.commands.SubCommand;
import com.balugaq.slimefuncoreprotect.core.commands.subcommands.DeleteCommand;
import com.balugaq.slimefuncoreprotect.core.commands.subcommands.HelpCommand;
import com.balugaq.slimefuncoreprotect.core.commands.subcommands.InspectCommand;
import com.balugaq.slimefuncoreprotect.core.commands.subcommands.LookupCommand;
import com.balugaq.slimefuncoreprotect.core.commands.subcommands.PageCommand;
import com.balugaq.slimefuncoreprotect.core.commands.subcommands.ReloadCommand;
import com.balugaq.slimefuncoreprotect.core.commands.subcommands.VersionCommand;
import com.balugaq.slimefuncoreprotect.core.listeners.MenuListener;
import com.balugaq.slimefuncoreprotect.implementation.SlimefunCoreProtect;
import com.google.common.base.Preconditions;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.chat.hover.content.Content;
import net.md_5.bungee.api.chat.hover.content.Text;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabExecutor;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommandManager
implements TabExecutor {
    private static final String EMPTY_PLACEHOLDER = "<hover><d></d><h></h></hover>";
    private static final Pattern CLICK_TAG_PATTERN = Pattern.compile("<a>(.*?)</a><v>(.*?)</v>", 32);
    private static final Pattern HOVER_TAG_PATTERN = Pattern.compile("<d>(.*?)</d><h>(.*?)</h>", 32);
    private static final Map<CommandSender, List<LogEntry>> lastLookup = new HashMap<CommandSender, List<LogEntry>>();
    private static final Map<CommandSender, Integer> pages = new HashMap<CommandSender, Integer>();
    private static final String ROOT_COMMAND = "slimefuncoreprotect";
    private static final int MAX_CONTENT_PER_PAGE = SlimefunCoreProtect.getInstance().getConfigManager().getMaxContentPerPage();
    private static final Pattern TAG_PATTERN = Pattern.compile("(.*?)(<(hover|click)>(.*?)</\\3>)", 32);
    @NotNull
    private final JavaPlugin plugin;
    private final List<SubCommand> subCommands = new ArrayList<SubCommand>();
    @NotNull
    private final SubCommand defaultCommand;

    public CommandManager(@NotNull JavaPlugin plugin) {
        Preconditions.checkNotNull((Object)plugin, (Object)"Plugin cannot be null");
        this.plugin = plugin;
        this.defaultCommand = new HelpCommand(plugin);
        this.setup();
        this.registerCommand();
    }

    public static String getEmptyPlaceholder() {
        return EMPTY_PLACEHOLDER;
    }

    public static Pattern getClickTagPattern() {
        return CLICK_TAG_PATTERN;
    }

    public static Pattern getHoverTagPattern() {
        return HOVER_TAG_PATTERN;
    }

    @NotNull
    public static String humanizeAction(@NotNull String actionStr) {
        return CommandManager.humanizeAction(Action.of(actionStr));
    }

    @NotNull
    public static String humanizeAction(@Nullable Action action) {
        if (action == null) {
            return "unknown";
        }
        return switch (action) {
            default -> throw new IncompatibleClassChangeError();
            case Action.BLOCK_PLACE -> "&a&l+block&r";
            case Action.BLOCK_BREAK -> "&c&l-block&r";
            case Action.MENU_OPEN -> "&a&l+menu&r";
            case Action.MENU_CLOSE -> "&c&l-menu&r";
            case Action.MENU_CLICK -> "&f&l?click&r";
            case Action.DROP_ITEM -> "&c&l-item&r";
            case Action.PICKUP_ITEM -> "&a&l+item&r";
            case Action.INTERACT_ITEM -> "&f&l?use&r";
            case Action.MENU_DRAG -> "&f&l?drag&r";
        };
    }

    @NotNull
    public static Action unhumanizeAction(@NotNull String actionStr) {
        return switch (actionStr.toLowerCase()) {
            case "+block" -> Action.BLOCK_PLACE;
            case "-block" -> Action.BLOCK_BREAK;
            case "+menu" -> Action.MENU_OPEN;
            case "-menu" -> Action.MENU_CLOSE;
            case "?click" -> Action.MENU_CLICK;
            case "-item" -> Action.DROP_ITEM;
            case "+item" -> Action.PICKUP_ITEM;
            case "?use" -> Action.INTERACT_ITEM;
            case "?drag" -> Action.MENU_DRAG;
            default -> Action.valueOf(actionStr.toUpperCase());
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void lookup(@NotNull CommandSender sender, @NotNull List<LogEntry> entries, String command) {
        Map<CommandSender, List<LogEntry>> map = CommandManager.getLastLookup();
        synchronized (map) {
            CommandManager.getLastLookup().put(sender, entries);
        }
        int currentPage = CommandManager.getCurrentPage(sender);
        Debug.debug("Current page: " + currentPage);
        List<LogEntry> splitted = CommandManager.splitEntries(entries, currentPage);
        for (LogEntry entry : splitted) {
            MenuListener.DragEntry dragEntry;
            String otherData;
            Location location = entry.getLocation();
            String delay = TimeUtil.getDelay(entry.getTime());
            String spaces = " ".repeat(delay.length() + 3);
            sender.spigot().sendMessage(CommandManager.formatMessage(Lang.getMessage("commands.lookups.common", "delay", delay, "player", entry.getPlayer(), "action", CommandManager.humanizeAction(entry.getAction()))));
            Action action = Action.of(entry.getAction());
            if (action == Action.MENU_CLICK) {
                otherData = entry.getOtherData();
                MenuListener.ClickEntry clickEntry = MenuListener.ClickEntry.fromString(otherData);
                if (clickEntry != null) {
                    CommandManager.newline();
                    sender.spigot().sendMessage(CommandManager.formatMessage(Lang.getMessage("commands.lookups.menu-click1", "spaces", spaces, "cursor", clickEntry.getCursor(), "clicked", clickEntry.getClicked(), "slot", clickEntry.getSlot(), "click_type", clickEntry.getClickType().name())));
                    CommandManager.newline();
                    sender.spigot().sendMessage(CommandManager.formatMessage(Lang.getMessage("commands.lookups.menu-click2", "spaces", spaces, "cursor", clickEntry.getCursor(), "clicked", clickEntry.getClicked(), "slot", clickEntry.getSlot(), "click_type", clickEntry.getClickType().name())));
                }
            } else if (action == Action.MENU_DRAG && (dragEntry = MenuListener.DragEntry.fromString(otherData = entry.getOtherData())) != null) {
                List slots = dragEntry.getSlots().stream().sorted().toList();
                CommandManager.newline();
                sender.spigot().sendMessage(CommandManager.formatMessage(Lang.getMessage("commands.lookups.menu-drag", "spaces", spaces, "cursor", dragEntry.getCursor(), "slots", slots.toString(), "drag_type", dragEntry.getDragType().name())));
            }
            if (location != null) {
                CommandManager.newline();
                sender.spigot().sendMessage(CommandManager.formatMessage(Lang.getMessage("commands.lookups.location", "spaces", spaces, "x", location.getBlockX(), "y", location.getBlockY(), "z", location.getBlockZ(), "world", location.getWorld().getName())));
            }
            CommandManager.newline();
            sender.spigot().sendMessage(CommandManager.formatMessage(Lang.getMessage("commands.lookups.slimefun-id", "spaces", spaces, "name", CommandManager.getName(entry.getSlimefunId()), "id", entry.getSlimefunId())));
        }
        if (!splitted.isEmpty()) {
            CommandManager.sendPageSwitch(sender, entries, command);
        } else {
            sender.sendMessage(Lang.getMessage("commands.lookup.no-logs-found"));
        }
    }

    public static void newline() {
    }

    @NotNull
    public static String getName(@NotNull String slimefunId) {
        SlimefunItem slimefunItem = SlimefunItem.getById((String)slimefunId);
        if (slimefunItem == null) {
            return slimefunId;
        }
        return slimefunItem.getItemName();
    }

    @NotNull
    public static List<LogEntry> splitEntries(@NotNull List<LogEntry> entries, int page) {
        if (entries.isEmpty()) {
            return entries;
        }
        int end = page * MAX_CONTENT_PER_PAGE;
        if (end > entries.size()) {
            end = entries.size();
        }
        int start = Math.max(0, end - MAX_CONTENT_PER_PAGE);
        return entries.subList(start, end);
    }

    public static int getCurrentPage(CommandSender sender) {
        return pages.computeIfAbsent(sender, k -> 1);
    }

    public static int getMaxPage(@NotNull List<LogEntry> entries) {
        int size = entries.size();
        if (size == 0) {
            return 1;
        }
        return (size + MAX_CONTENT_PER_PAGE - 1) / MAX_CONTENT_PER_PAGE;
    }

    public static BaseComponent @NotNull [] formatMessage(@NotNull String message) {
        ComponentBuilder builder = new ComponentBuilder();
        try {
            while (!message.isEmpty()) {
                Matcher matcher = TAG_PATTERN.matcher(message);
                if (!matcher.find()) {
                    builder.append(CommandManager.format(message));
                    break;
                }
                String normalText = matcher.group(1);
                if (!normalText.isEmpty()) {
                    builder.append(CommandManager.format(normalText));
                }
                String tagType = matcher.group(3);
                String tagContent = matcher.group(4);
                if ("hover".equals(tagType)) {
                    CommandManager.processHoverTag(builder, tagContent);
                } else if ("click".equals(tagType)) {
                    CommandManager.processClickTag(builder, tagContent);
                }
                message = message.substring(matcher.end(2));
            }
        }
        catch (Exception e) {
            builder.append(Lang.getMessage("commands.unable-to-deserialize", "text", message));
            e.printStackTrace();
        }
        return builder.create();
    }

    private static void processHoverTag(@NotNull ComponentBuilder builder, @NotNull String content) {
        Matcher m = HOVER_TAG_PATTERN.matcher(content);
        if (m.find()) {
            BaseComponent[] displays = TextComponent.fromLegacyText((String)CommandManager.format(m.group(1)));
            BaseComponent[] hover = TextComponent.fromLegacyText((String)CommandManager.format(m.group(2)));
            TextComponent display = new TextComponent(new BaseComponent[]{displays[0]});
            for (int i = 1; i < displays.length; ++i) {
                display.addExtra(displays[i]);
            }
            builder.append((BaseComponent)display).event(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new Content[]{new Text(hover)}));
        }
    }

    private static void processClickTag(@NotNull ComponentBuilder builder, @NotNull String content) {
        Matcher m = CLICK_TAG_PATTERN.matcher(content);
        if (m.find()) {
            String action = m.group(1).trim().toUpperCase();
            String value = m.group(2).trim();
            try {
                ClickEvent.Action clickAction = ClickEvent.Action.valueOf((String)action);
                builder.event(new ClickEvent(clickAction, value));
            }
            catch (IllegalArgumentException e) {
                builder.append(Lang.getMessage("commands.unknown-click-action", "action", action));
                e.printStackTrace();
            }
        }
    }

    @NotNull
    public static String format(@NotNull String message) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }

    public static void sendPageSwitch(@NotNull CommandSender sender, @NotNull List<LogEntry> entries, @Nullable String command) {
        sender.spigot().sendMessage(CommandManager.formatMessage("&a\u7b2c " + CommandManager.getCurrentPage(sender) + " / " + CommandManager.getMaxPage(entries) + " \u9875.<hover><d></d><h></h></hover> <hover><d>&b<\u4e0a\u4e00\u9875></d><h>&b<\u4e0a\u4e00\u9875></h></hover><click><a>run_command</a><v>/sco page " + Math.max(1, CommandManager.getCurrentPage(sender) - 1) + "</v></click> <hover><d>&b<\u4e0b\u4e00\u9875></d><h>&b<\u4e0b\u4e00\u9875></h></hover><click><a>run_command</a><v>/sco page " + Math.min(CommandManager.getCurrentPage(sender) + 1, CommandManager.getMaxPage(entries)) + "</v></click>"));
    }

    public void setup() {
        this.subCommands.add(new HelpCommand(this.plugin));
        this.subCommands.add(new ReloadCommand(this.plugin));
        this.subCommands.add(new VersionCommand(this.plugin));
        this.subCommands.add(new LookupCommand(this.plugin));
        this.subCommands.add(new PageCommand(this.plugin));
        this.subCommands.add(new DeleteCommand(this.plugin));
        this.subCommands.add(new InspectCommand(this.plugin));
    }

    public void registerCommand() {
        PluginCommand command = this.plugin.getCommand(ROOT_COMMAND);
        if (command == null) {
            this.plugin.getLogger().severe("Command \"slimefuncoreprotect\" not found!");
            return;
        }
        command.setExecutor((CommandExecutor)this);
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (!sender.isOp()) {
            sender.sendMessage(Lang.getMessage("commands.no-permission"));
            return true;
        }
        for (SubCommand subCommand : this.subCommands) {
            if (!subCommand.canCommand(sender, command, label, args)) continue;
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> subCommand.onCommand(sender, command, label, args));
            return true;
        }
        return this.defaultCommand.onCommand(sender, command, label, args);
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull @NotNull String @NotNull [] args) {
        List<String> subCommandNames = this.subCommands.stream().map(SubCommand::getName).toList();
        if (args.length <= 1) {
            return subCommandNames;
        }
        ArrayList<String> completions = new ArrayList<String>();
        for (SubCommand subCommand : this.subCommands) {
            List<String> subCompletion = subCommand.onTabComplete(sender, command, label, args);
            if (subCompletion == null) continue;
            completions.addAll(subCompletion);
        }
        return completions;
    }

    @NotNull
    @Generated
    public JavaPlugin getPlugin() {
        return this.plugin;
    }

    @Generated
    public List<SubCommand> getSubCommands() {
        return this.subCommands;
    }

    @NotNull
    @Generated
    public SubCommand getDefaultCommand() {
        return this.defaultCommand;
    }

    @Generated
    public static Map<CommandSender, List<LogEntry>> getLastLookup() {
        return lastLookup;
    }

    @Generated
    public static Map<CommandSender, Integer> getPages() {
        return pages;
    }
}

