/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.slimefuncoreprotect.api.logs;

import com.balugaq.slimefuncoreprotect.api.QueryUser;
import com.balugaq.slimefuncoreprotect.api.logs.DatabaseManager;
import com.balugaq.slimefuncoreprotect.api.logs.LogEntry;
import com.balugaq.slimefuncoreprotect.api.utils.Debug;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class LogDao {
    private static final long THRESHOLD = 1000L;

    public static void deleteLog(String user, Timestamp time, String action, String location, String slimefunId) {
        String sql = "DELETE FROM user_logs WHERE user = ? AND time = ? AND action = ? AND location = ? AND slimefun_id = ?";
        try (Connection conn = DatabaseManager.getDataSource().getConnection();
             PreparedStatement pstmt = conn.prepareStatement(sql);){
            pstmt.setString(1, user);
            pstmt.setTimestamp(2, time);
            pstmt.setString(3, action);
            pstmt.setString(4, location);
            pstmt.setString(5, slimefunId);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static void insertLog(String user, Timestamp time, String action, String location, String slimefunId) {
        String sql = "INSERT INTO user_logs (user, time, action, location, slimefun_id, other_data, status) VALUES (?, ?, ?, ?, ?, ?, ?)";
        try (Connection conn = DatabaseManager.getDataSource().getConnection();
             PreparedStatement pstmt = conn.prepareStatement(sql);){
            pstmt.setString(1, user);
            pstmt.setTimestamp(2, time);
            pstmt.setString(3, action);
            pstmt.setString(4, location);
            pstmt.setString(5, slimefunId);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static void insertLog(String user, Timestamp time, String action, String location, String slimefunId, String otherData) {
        String sql = "INSERT INTO user_logs (user, time, action, location, slimefun_id, other_data, status) VALUES (?, ?, ?, ?, ?, ?, ?)";
        try (Connection conn = DatabaseManager.getDataSource().getConnection();
             PreparedStatement pstmt = conn.prepareStatement(sql);){
            pstmt.setString(1, user);
            pstmt.setTimestamp(2, time);
            pstmt.setString(3, action);
            pstmt.setString(4, location);
            pstmt.setString(5, slimefunId);
            pstmt.setString(6, otherData);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @NotNull
    public static List<LogEntry> getLogs(@NotNull QueryUser user, @NotNull Map<String, String> sections) {
        StringBuilder sql = new StringBuilder("SELECT * FROM user_logs");
        ArrayList<Object> params = new ArrayList<Object>();
        ArrayList<String> conditions = new ArrayList<String>();
        if (sections.containsKey("user:")) {
            conditions.add("user = ?");
            params.add(sections.get("user:"));
        }
        if (sections.containsKey("time:")) {
            conditions.add("time BETWEEN ? AND ?");
            long range = LogDao.getTime(sections.get("time:"));
            long now = System.currentTimeMillis();
            params.add(new Timestamp(now - range));
            params.add(new Timestamp(now));
        }
        if (sections.containsKey("action:")) {
            conditions.add("action = ?");
            params.add(sections.get("action:"));
        }
        if (sections.containsKey("location:")) {
            conditions.add("location = ?");
            params.add(sections.get("location:"));
        }
        if (sections.containsKey("slimefun_id:")) {
            conditions.add("slimefun_id = ?");
            params.add(sections.get("slimefun_id:"));
        }
        if (!conditions.isEmpty()) {
            sql.append(" WHERE ");
            sql.append(String.join((CharSequence)" AND ", conditions));
        }
        Debug.log("SQL: " + sql.toString());
        Debug.log("Params: " + ((Object)params).toString());
        return LogDao.query(user, sql.toString(), params.toArray());
    }

    public static long getTime(@NotNull String time) {
        if (time.endsWith("s")) {
            return (long)(Double.parseDouble(time.replace("s", "")) * 1000.0);
        }
        if (time.endsWith("m")) {
            return (long)(Double.parseDouble(time.replace("m", "")) * 60000.0);
        }
        if (time.endsWith("h")) {
            return (long)(Double.parseDouble(time.replace("h", "")) * 3600000.0);
        }
        if (time.endsWith("d")) {
            return (long)(Double.parseDouble(time.replace("d", "")) * 8.64E7);
        }
        return 0L;
    }

    @NotNull
    public static List<LogEntry> getLogsByUser(@NotNull QueryUser user, String u) {
        String sql = "SELECT * FROM user_logs WHERE user = ?";
        return LogDao.query(user, sql, u);
    }

    @NotNull
    public static List<LogEntry> getLogsByTime(@NotNull QueryUser user, Timestamp time) {
        String sql = "SELECT * FROM user_logs WHERE time = ?";
        return LogDao.query(user, sql, time);
    }

    @NotNull
    public static List<LogEntry> getLogsBetween(@NotNull QueryUser user, Timestamp start, Timestamp end) {
        String sql = "SELECT * FROM user_logs WHERE time BETWEEN ? AND ?";
        return LogDao.query(user, sql, start, end);
    }

    @NotNull
    public static List<LogEntry> getLogsByAction(@NotNull QueryUser user, String action) {
        String sql = "SELECT * FROM user_logs WHERE action = ?";
        return LogDao.query(user, sql, action);
    }

    @NotNull
    public static List<LogEntry> getLogsByLocation(@NotNull QueryUser user, String location) {
        String sql = "SELECT * FROM user_logs WHERE location = ?";
        return LogDao.query(user, sql, location);
    }

    @NotNull
    public static List<LogEntry> getLogsBySlimefunId(@NotNull QueryUser user, String slimefunId) {
        String sql = "SELECT * FROM user_logs WHERE slimefun_id = ?";
        return LogDao.query(user, sql, slimefunId);
    }

    @NotNull
    public static List<LogEntry> getAllLogs(@NotNull QueryUser user) {
        String sql = "SELECT * FROM user_logs";
        return LogDao.query(user, sql, new Object[0]);
    }

    @NotNull
    private static List<LogEntry> query(@NotNull QueryUser user, String sql, Object ... params) {
        if (!QueryUser.isOutdated(user, 1000L)) {
            user.sendMessage("You can only query logs once every 1 seconds.");
            return new ArrayList<LogEntry>();
        }
        QueryUser.updateLastQueryTime(user);
        ArrayList<LogEntry> logs = new ArrayList<LogEntry>();
        try (Connection conn = DatabaseManager.getDataSource().getConnection();
             PreparedStatement pstmt = conn.prepareStatement(sql);){
            for (int i = 0; i < params.length; ++i) {
                pstmt.setObject(i + 1, params[i]);
            }
            try (ResultSet rs = pstmt.executeQuery();){
                while (rs.next()) {
                    LogEntry log = new LogEntry();
                    log.setId(rs.getInt("id"));
                    log.setPlayer(rs.getString("user"));
                    log.setTime(rs.getLong("time"));
                    log.setAction(rs.getString("action"));
                    log.setLocation(rs.getString("location"));
                    log.setSlimefunId(rs.getString("slimefun_id"));
                    log.setOtherData(rs.getString("other_data"));
                    logs.add(log);
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        ArrayList<LogEntry> reversedLogs = new ArrayList<LogEntry>();
        for (int i = logs.size() - 1; i >= 0; --i) {
            reversedLogs.add((LogEntry)logs.get(i));
        }
        return reversedLogs;
    }
}

