/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.slimefuncoreprotect.core.managers;

import com.balugaq.slimefuncoreprotect.core.listeners.BlockListener;
import com.balugaq.slimefuncoreprotect.core.listeners.InspectListener;
import com.balugaq.slimefuncoreprotect.core.listeners.MenuListener;
import com.balugaq.slimefuncoreprotect.core.listeners.PlayerListener;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class ListenerManager {
    @NotNull
    private final JavaPlugin plugin;
    @NotNull
    private final List<Listener> listeners;

    public ListenerManager(@NotNull JavaPlugin plugin) {
        this.plugin = plugin;
        this.listeners = new ArrayList<Listener>();
    }

    public void setup() {
        this.listeners.add(new BlockListener());
        this.listeners.add(new MenuListener());
        this.listeners.add(new PlayerListener());
        this.listeners.add(new InspectListener());
    }

    public void load() {
        for (Listener listener : this.listeners) {
            Bukkit.getPluginManager().registerEvents(listener, (Plugin)this.plugin);
        }
    }

    public void unload() {
        for (Listener listener : this.listeners) {
            HandlerList.unregisterAll((Listener)listener);
        }
    }

    @NotNull
    @Generated
    public JavaPlugin getPlugin() {
        return this.plugin;
    }

    @NotNull
    @Generated
    public List<Listener> getListeners() {
        return this.listeners;
    }
}

