/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.slimefuncoreprotect.core.listeners;

import com.balugaq.slimefuncoreprotect.api.enums.Action;
import com.balugaq.slimefuncoreprotect.api.logs.LogDao;
import com.balugaq.slimefuncoreprotect.api.logs.LogEntry;
import com.balugaq.slimefuncoreprotect.api.utils.Debug;
import com.balugaq.slimefuncoreprotect.api.utils.TimeUtil;
import com.balugaq.slimefuncoreprotect.implementation.SlimefunCoreProtect;
import io.github.thebusybiscuit.slimefun4.api.events.SlimefunItemRegistryFinalizedEvent;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.ItemUtils;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.UUID;
import lombok.Generated;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenuPreset;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.DragType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MenuListener
implements Listener {
    private static final String UNDEFINED = "undefined";
    private static final Set<UUID> opening = new HashSet<UUID>();
    private static final boolean isCNSlimefun = SlimefunCoreProtect.getInstance().getIntegrationManager().isCNSlimefun();

    @NotNull
    public static String getUndefined() {
        return UNDEFINED;
    }

    @NotNull
    public static String getDragString(@NotNull InventoryDragEvent event) {
        return new DragEntry(event.getType(), event.getRawSlots(), ItemUtils.getItemName((ItemStack)event.getWhoClicked().getItemOnCursor())).toString();
    }

    @NotNull
    public static String getSlotsString(@NotNull Set<Integer> slots) {
        if (slots.isEmpty()) {
            return UNDEFINED;
        }
        StringBuilder str = new StringBuilder();
        Iterator iterator = slots.stream().sorted().toList().iterator();
        while (iterator.hasNext()) {
            int slot = (Integer)iterator.next();
            str.append(slot).append(",");
        }
        if (str.charAt(str.length() - 1) == ',') {
            str = new StringBuilder(str.substring(0, str.length() - 1));
        }
        return str.toString();
    }

    @NotNull
    public static String getClickString(@NotNull InventoryClickEvent event) {
        return new ClickEntry(event.getClick(), event.getAction(), event.getRawSlot(), ItemUtils.getItemName((ItemStack)event.getWhoClicked().getItemOnCursor()), ItemUtils.getItemName((ItemStack)event.getWhoClicked().getItemOnCursor())).toString();
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onInit(SlimefunItemRegistryFinalizedEvent event) {
        for (BlockMenuPreset preset : Slimefun.getRegistry().getMenuPresets().values()) {
            ChestMenu.MenuCloseHandler closeHandler;
            ChestMenu.MenuOpeningHandler handler = preset.getMenuOpeningHandler();
            if (handler != null) {
                preset.addMenuOpeningHandler(p -> {
                    Debug.debug("Insert menu open log");
                    opening.add(p.getUniqueId());
                    Block block = p.getTargetBlockExact(8, FluidCollisionMode.NEVER);
                    LogDao.insertLog(p.getName(), TimeUtil.now(), Action.MENU_OPEN.getKey(), block == null ? "unknown" : LogEntry.getStringBlockLocation(block.getLocation()), preset.getID());
                    handler.onOpen(p);
                });
            }
            if ((closeHandler = preset.getMenuCloseHandler()) == null) continue;
            preset.addMenuCloseHandler(p -> {
                Debug.debug("Insert menu close log");
                opening.remove(p.getUniqueId());
                Block block = p.getTargetBlockExact(8, FluidCollisionMode.NEVER);
                LogDao.insertLog(p.getName(), TimeUtil.now(), Action.MENU_CLOSE.getKey(), block == null ? "unknown" : LogEntry.getStringBlockLocation(block.getLocation()), preset.getID());
                closeHandler.onClose(p);
            });
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onMenuClick(@NotNull InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        if (opening.contains(player.getUniqueId())) {
            if (isCNSlimefun) {
                InventoryHolder inventoryHolder = event.getInventory().getHolder();
                if (inventoryHolder instanceof BlockMenu) {
                    BlockMenu menu = (BlockMenu)inventoryHolder;
                    Debug.debug("Insert menu click log");
                    LogDao.insertLog(player.getName(), TimeUtil.now(), Action.MENU_CLICK.getKey(), LogEntry.getStringBlockLocation(event.getInventory().getLocation()), menu.getPreset().getID(), MenuListener.getClickString(event));
                }
            } else {
                Block block = player.getTargetBlockExact(8, FluidCollisionMode.NEVER);
                SlimefunItem item = BlockStorage.check((Location)block.getLocation());
                if (item != null) {
                    Debug.debug("Insert menu click log");
                    LogDao.insertLog(player.getName(), TimeUtil.now(), Action.MENU_CLICK.getKey(), LogEntry.getStringBlockLocation(block.getLocation()), item.getId(), MenuListener.getClickString(event));
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onMenuDrag(@NotNull InventoryDragEvent event) {
        Player player = (Player)event.getWhoClicked();
        if (opening.contains(player.getUniqueId())) {
            if (isCNSlimefun) {
                InventoryHolder inventoryHolder = event.getInventory().getHolder();
                if (inventoryHolder instanceof BlockMenu) {
                    BlockMenu menu = (BlockMenu)inventoryHolder;
                    Debug.debug("Insert menu drag log");
                    LogDao.insertLog(player.getName(), TimeUtil.now(), Action.MENU_DRAG.getKey(), LogEntry.getStringBlockLocation(event.getInventory().getLocation()), menu.getPreset().getID(), MenuListener.getDragString(event));
                }
            } else {
                Block block = player.getTargetBlockExact(8, FluidCollisionMode.NEVER);
                SlimefunItem item = BlockStorage.check((Location)block.getLocation());
                if (item != null) {
                    Debug.debug("Insert menu drag log");
                    LogDao.insertLog(player.getName(), TimeUtil.now(), Action.MENU_DRAG.getKey(), LogEntry.getStringBlockLocation(block.getLocation()), item.getId(), MenuListener.getDragString(event));
                }
            }
        }
    }

    public static class DragEntry {
        @NotNull
        private final DragType dragType;
        @NotNull
        private final Set<Integer> slots;
        @NotNull
        private final String cursor;

        @Nullable
        public static DragEntry fromString(@NotNull String str) {
            String[] slotParts;
            String[] parts = str.split(";");
            if (parts.length != 3) {
                return null;
            }
            DragType dragType = DragType.valueOf((String)parts[0]);
            HashSet<Integer> slots = new HashSet<Integer>();
            for (String slot : slotParts = parts[1].split(",")) {
                if (slot.equals(MenuListener.UNDEFINED)) {
                    return null;
                }
                try {
                    slots.add(Integer.parseInt(slot));
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
            String itemName = parts[2];
            return new DragEntry(dragType, slots, itemName);
        }

        @NotNull
        public String toString() {
            return this.dragType.name() + ";" + MenuListener.getSlotsString(this.slots) + ";" + this.cursor;
        }

        @Generated
        public DragEntry(@NotNull DragType dragType, @NotNull Set<Integer> slots, @NotNull String cursor) {
            if (dragType == null) {
                throw new NullPointerException("dragType is marked non-null but is null");
            }
            if (slots == null) {
                throw new NullPointerException("slots is marked non-null but is null");
            }
            if (cursor == null) {
                throw new NullPointerException("cursor is marked non-null but is null");
            }
            this.dragType = dragType;
            this.slots = slots;
            this.cursor = cursor;
        }

        @NotNull
        @Generated
        public DragType getDragType() {
            return this.dragType;
        }

        @NotNull
        @Generated
        public Set<Integer> getSlots() {
            return this.slots;
        }

        @NotNull
        @Generated
        public String getCursor() {
            return this.cursor;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DragEntry)) {
                return false;
            }
            DragEntry other = (DragEntry)o;
            if (!other.canEqual(this)) {
                return false;
            }
            DragType this$dragType = this.getDragType();
            DragType other$dragType = other.getDragType();
            if (this$dragType == null ? other$dragType != null : !this$dragType.equals(other$dragType)) {
                return false;
            }
            Set<Integer> this$slots = this.getSlots();
            Set<Integer> other$slots = other.getSlots();
            if (this$slots == null ? other$slots != null : !((Object)this$slots).equals(other$slots)) {
                return false;
            }
            String this$cursor = this.getCursor();
            String other$cursor = other.getCursor();
            return !(this$cursor == null ? other$cursor != null : !this$cursor.equals(other$cursor));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof DragEntry;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            DragType $dragType = this.getDragType();
            result = result * 59 + ($dragType == null ? 43 : $dragType.hashCode());
            Set<Integer> $slots = this.getSlots();
            result = result * 59 + ($slots == null ? 43 : ((Object)$slots).hashCode());
            String $cursor = this.getCursor();
            result = result * 59 + ($cursor == null ? 43 : $cursor.hashCode());
            return result;
        }
    }

    public static class ClickEntry {
        @NotNull
        private final ClickType clickType;
        @NotNull
        private final InventoryAction action;
        private final int slot;
        @NotNull
        private final String cursor;
        @NotNull
        private final String clicked;

        @Nullable
        public static ClickEntry fromString(@NotNull String str) {
            int slot;
            String[] parts = str.split(";");
            if (parts.length != 5) {
                return null;
            }
            ClickType clickType = ClickType.valueOf((String)parts[0]);
            InventoryAction action = InventoryAction.valueOf((String)parts[1]);
            try {
                slot = Integer.parseInt(parts[2]);
            }
            catch (NumberFormatException e) {
                return null;
            }
            String cursor = parts[3];
            String clicked = parts[4];
            return new ClickEntry(clickType, action, slot, cursor, clicked);
        }

        @NotNull
        public String toString() {
            return this.clickType.name() + ";" + this.action.name() + ";" + this.slot + ";" + this.cursor + ";" + this.clicked;
        }

        @Generated
        public ClickEntry(@NotNull ClickType clickType, @NotNull InventoryAction action, int slot, @NotNull String cursor, @NotNull String clicked) {
            if (clickType == null) {
                throw new NullPointerException("clickType is marked non-null but is null");
            }
            if (action == null) {
                throw new NullPointerException("action is marked non-null but is null");
            }
            if (cursor == null) {
                throw new NullPointerException("cursor is marked non-null but is null");
            }
            if (clicked == null) {
                throw new NullPointerException("clicked is marked non-null but is null");
            }
            this.clickType = clickType;
            this.action = action;
            this.slot = slot;
            this.cursor = cursor;
            this.clicked = clicked;
        }

        @NotNull
        @Generated
        public ClickType getClickType() {
            return this.clickType;
        }

        @NotNull
        @Generated
        public InventoryAction getAction() {
            return this.action;
        }

        @Generated
        public int getSlot() {
            return this.slot;
        }

        @NotNull
        @Generated
        public String getCursor() {
            return this.cursor;
        }

        @NotNull
        @Generated
        public String getClicked() {
            return this.clicked;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ClickEntry)) {
                return false;
            }
            ClickEntry other = (ClickEntry)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getSlot() != other.getSlot()) {
                return false;
            }
            ClickType this$clickType = this.getClickType();
            ClickType other$clickType = other.getClickType();
            if (this$clickType == null ? other$clickType != null : !this$clickType.equals(other$clickType)) {
                return false;
            }
            InventoryAction this$action = this.getAction();
            InventoryAction other$action = other.getAction();
            if (this$action == null ? other$action != null : !this$action.equals(other$action)) {
                return false;
            }
            String this$cursor = this.getCursor();
            String other$cursor = other.getCursor();
            if (this$cursor == null ? other$cursor != null : !this$cursor.equals(other$cursor)) {
                return false;
            }
            String this$clicked = this.getClicked();
            String other$clicked = other.getClicked();
            return !(this$clicked == null ? other$clicked != null : !this$clicked.equals(other$clicked));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ClickEntry;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getSlot();
            ClickType $clickType = this.getClickType();
            result = result * 59 + ($clickType == null ? 43 : $clickType.hashCode());
            InventoryAction $action = this.getAction();
            result = result * 59 + ($action == null ? 43 : $action.hashCode());
            String $cursor = this.getCursor();
            result = result * 59 + ($cursor == null ? 43 : $cursor.hashCode());
            String $clicked = this.getClicked();
            result = result * 59 + ($clicked == null ? 43 : $clicked.hashCode());
            return result;
        }
    }
}

