/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.slimefuncoreprotect.core.commands.subcommands;

import com.balugaq.slimefuncoreprotect.api.QueryUser;
import com.balugaq.slimefuncoreprotect.api.enums.Action;
import com.balugaq.slimefuncoreprotect.api.logs.LogDao;
import com.balugaq.slimefuncoreprotect.api.logs.LogEntry;
import com.balugaq.slimefuncoreprotect.api.utils.Debug;
import com.balugaq.slimefuncoreprotect.api.utils.Lang;
import com.balugaq.slimefuncoreprotect.api.utils.NotHumanUsers;
import com.balugaq.slimefuncoreprotect.core.commands.SubCommand;
import com.balugaq.slimefuncoreprotect.core.listeners.MenuListener;
import com.balugaq.slimefuncoreprotect.core.listeners.PlayerListener;
import com.balugaq.slimefuncoreprotect.core.managers.CommandManager;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LookupCommand
extends SubCommand {
    private static final Set<String> SLIMEFUN_ITEM_IDS = new HashSet<String>();
    private static final Set<String> SECTIONS = new HashSet<String>();
    private static final Map<String, List<Action>> UNCOMMON_SECTIONS = new HashMap<String, List<Action>>();
    private static final Map<CommandSender, QueryUser> queryUsers = new HashMap<CommandSender, QueryUser>();

    public LookupCommand(@NotNull JavaPlugin plugin) {
        super(plugin);
    }

    public static Set<String> getSlimefunItemIds() {
        return SLIMEFUN_ITEM_IDS;
    }

    public static Set<String> getSections() {
        return SECTIONS;
    }

    public static Map<String, List<Action>> getUncommonSections() {
        return UNCOMMON_SECTIONS;
    }

    @Nullable
    public static Action getAction(String @NotNull [] args) {
        for (String arg : args) {
            if (!arg.equals("action:")) continue;
            return Action.valueOf(arg.replace("action:", "").trim());
        }
        return null;
    }

    @NotNull
    public static Map<String, String> getCommandArgs(String @NotNull [] args) {
        HashMap<String, String> commandArgs = new HashMap<String, String>();
        for (String arg : args) {
            for (String section : SECTIONS) {
                if (!arg.startsWith(section)) continue;
                String value = arg.replace(section, "").trim();
                if (section.equals("action:")) {
                    Action action = CommandManager.unhumanizeAction(value);
                    commandArgs.put(section, action.getKey());
                    continue;
                }
                commandArgs.put(section, value);
            }
        }
        return commandArgs;
    }

    public static boolean handleOtherLookupArgs(String @NotNull [] args, @Nullable Action action, @NotNull CommandSender sender, @NotNull List<LogEntry> entries, @NotNull List<LogEntry> removes) {
        for (String arg : args) {
            block13: for (String section : UNCOMMON_SECTIONS.keySet()) {
                if (!arg.startsWith(section)) continue;
                List<Action> allowedActions = UNCOMMON_SECTIONS.get(section);
                if (allowedActions != null && allowedActions.size() != Action.values().length) {
                    if (action == null) {
                        sender.sendMessage(Lang.getMessage("commands.lookup.no-action-specified", "section", section));
                        return false;
                    }
                    if (!allowedActions.contains((Object)action)) {
                        sender.sendMessage(Lang.getMessage("commands.lookup.not-allowed-action", "section", section, "action", CommandManager.humanizeAction(action)));
                        return false;
                    }
                }
                switch (section) {
                    case "cursor:": {
                        MenuListener.ClickEntry clickEntry;
                        String value = arg.replace(section, "").trim();
                        for (LogEntry entry : entries) {
                            if (entry.getOtherData() == null) {
                                removes.add(entry);
                                continue;
                            }
                            clickEntry = MenuListener.ClickEntry.fromString(entry.getOtherData());
                            if (clickEntry == null) {
                                MenuListener.DragEntry dragEntry = MenuListener.DragEntry.fromString(entry.getOtherData());
                                if (dragEntry == null) {
                                    removes.add(entry);
                                    continue;
                                }
                                if (dragEntry.getCursor().contains(value)) continue;
                                removes.add(entry);
                                continue;
                            }
                            if (clickEntry.getCursor().contains(value)) continue;
                            removes.add(entry);
                        }
                        continue block13;
                    }
                    case "clicked:": {
                        MenuListener.ClickEntry clickEntry;
                        String value = arg.replace(section, "").trim();
                        for (LogEntry entry : entries) {
                            if (entry.getOtherData() == null) {
                                removes.add(entry);
                                continue;
                            }
                            clickEntry = MenuListener.ClickEntry.fromString(entry.getOtherData());
                            if (clickEntry == null) {
                                removes.add(entry);
                                continue;
                            }
                            if (clickEntry.getClicked().contains(value)) continue;
                            removes.add(entry);
                        }
                        continue block13;
                    }
                    case "iaction:": {
                        String value = arg.replace(section, "").trim();
                        for (LogEntry entry : entries) {
                            if (entry.getOtherData() == null) {
                                removes.add(entry);
                                continue;
                            }
                            PlayerListener.ActionEntry actionEntry = PlayerListener.ActionEntry.fromString(entry.getOtherData());
                            if (actionEntry == null) {
                                removes.add(entry);
                                continue;
                            }
                            if (actionEntry.getAction().name().contains(value)) continue;
                            removes.add(entry);
                        }
                        continue block13;
                    }
                    case "radius:": {
                        if (!(sender instanceof Player)) {
                            sender.sendMessage(Lang.getMessage("commands.lookup.not-player-for-radius-section"));
                            return false;
                        }
                        Player player = (Player)sender;
                        Location center = player.getLocation();
                        World world = center.getWorld();
                        String value = arg.replace(section, "").trim();
                        double radius = Double.parseDouble(value);
                        for (LogEntry entry : entries) {
                            Location location = entry.getLocation();
                            if (location == null) {
                                removes.add(entry);
                                continue;
                            }
                            if (world != location.getWorld()) {
                                removes.add(entry);
                                continue;
                            }
                            if (!(location.distance(center) > radius)) continue;
                            removes.add(entry);
                        }
                        break;
                    }
                }
            }
        }
        return true;
    }

    @Override
    @NotNull
    public String getName() {
        return "lookup";
    }

    @Override
    public boolean canCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull @NotNull String @NotNull [] args) {
        if (args.length == 0) {
            return false;
        }
        return this.getName().equalsIgnoreCase(args[0]);
    }

    @Override
    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull @NotNull String @NotNull [] args) {
        ArrayList<LogEntry> removes;
        List<LogEntry> entries;
        Debug.debug("Lookup command executed.");
        StringBuilder c = new StringBuilder("/sco lookup ");
        for (String arg : args) {
            c.append(arg).append(" ");
        }
        c = new StringBuilder(c.toString().trim());
        Action action = LookupCommand.getAction(args);
        Map<String, String> commandArgs = LookupCommand.getCommandArgs(args);
        for (Map.Entry<String, String> entry : commandArgs.entrySet()) {
            Debug.debug("Command arg: " + entry.getKey() + " = " + entry.getValue());
        }
        if (!queryUsers.containsKey(sender)) {
            queryUsers.put(sender, QueryUser.create(sender));
        }
        if ((entries = LogDao.getLogs(queryUsers.get(sender), commandArgs)).isEmpty()) {
            sender.sendMessage(Lang.getMessage("commands.lookup.no-logs-found"));
            return true;
        }
        if (args.length == 1) {
            args = new String[]{"radius:10"};
        }
        if (!LookupCommand.handleOtherLookupArgs(args, action, sender, entries, removes = new ArrayList<LogEntry>())) {
            return false;
        }
        entries.removeAll(removes);
        CommandManager.lookup(sender, entries, c.toString());
        return true;
    }

    @Override
    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull @NotNull String @NotNull [] args) {
        String s;
        HashSet<String> phase1 = new HashSet<String>();
        HashSet<String> contains = new HashSet<String>();
        for (String arg : args) {
            String[] parts;
            if (!arg.contains(":") || (parts = arg.split(":")).length != 2) continue;
            String section = parts[0].trim();
            contains.add(section);
        }
        for (String section : SECTIONS) {
            if (contains.contains(section.split(":")[0].trim())) continue;
            phase1.add(section);
        }
        for (String section : UNCOMMON_SECTIONS.keySet()) {
            if (contains.contains(section.split(":")[0].trim())) continue;
            phase1.add(section);
        }
        HashSet<Object> phase2 = new HashSet<Object>();
        String last = args[((String[])args).length - 1];
        if (last.startsWith("action:")) {
            for (Action action : Action.values()) {
                String s2 = "action:" + ChatColor.stripColor((String)ChatColor.translateAlternateColorCodes((char)'&', (String)CommandManager.humanizeAction(action)));
                phase2.add(s2);
            }
        }
        if (last.startsWith("user:")) {
            for (Player player : Bukkit.getOnlinePlayers()) {
                String s3 = "user:" + player.getName();
                phase2.add(s3);
            }
            for (String string : NotHumanUsers.getNotHumanUsers()) {
                String s4 = "user:" + string;
                phase2.add(s4);
            }
        }
        if (last.startsWith("location:") && sender instanceof Player) {
            Player player = (Player)sender;
            Block block = player.getTargetBlockExact(8, FluidCollisionMode.NEVER);
            Location location = null;
            location = block != null ? block.getLocation() : player.getLocation();
            s = "location:" + LogEntry.getStringBlockLocation(location);
            phase2.add(s);
        }
        if (last.startsWith("slimefunid:")) {
            for (String id : SLIMEFUN_ITEM_IDS) {
                String s5 = "slimefunid:" + id;
                phase2.add(s5);
            }
        }
        List<String> times = List.of("1m", "10m", "30m", "1h", "12h", "1d", "30d");
        if (last.startsWith("time:")) {
            for (String time : times) {
                s = "time:" + time;
                phase2.add(s);
            }
        }
        ArrayList<Object> rawResult = new ArrayList<Object>();
        rawResult.addAll(phase2);
        rawResult.addAll(phase1);
        ArrayList<String> removed = new ArrayList<String>();
        for (String arg : args) {
            if (!rawResult.contains(arg)) continue;
            removed.add(arg);
        }
        ArrayList<String> result = new ArrayList<String>(rawResult);
        result.removeAll(removed);
        return result;
    }

    static {
        SECTIONS.add("action:");
        SECTIONS.add("user:");
        SECTIONS.add("location:");
        SECTIONS.add("slimefunid:");
        SECTIONS.add("time:");
        UNCOMMON_SECTIONS.put("cursor:", List.of(Action.MENU_CLICK, Action.MENU_DRAG));
        UNCOMMON_SECTIONS.put("clicked:", List.of(Action.MENU_CLICK));
        UNCOMMON_SECTIONS.put("radius:", List.of(Action.values()));
        UNCOMMON_SECTIONS.put("iaction:", List.of(Action.INTERACT_ITEM));
        for (SlimefunItem item : Slimefun.getRegistry().getAllSlimefunItems()) {
            SLIMEFUN_ITEM_IDS.add(item.getId());
        }
    }
}

