/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.slimefuncoreprotect.core.listeners;

import com.balugaq.slimefuncoreprotect.api.enums.Action;
import com.balugaq.slimefuncoreprotect.api.logs.LogDao;
import com.balugaq.slimefuncoreprotect.api.logs.LogEntry;
import com.balugaq.slimefuncoreprotect.api.utils.Debug;
import com.balugaq.slimefuncoreprotect.api.utils.TimeUtil;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import lombok.Generated;
import org.bukkit.block.Block;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerListener
implements Listener {
    @NotNull
    public static String getActionString(@NotNull PlayerInteractEvent event) {
        return new ActionEntry(event.getAction()).toString();
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerPickupItem(@NotNull EntityPickupItemEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            SlimefunItem item = SlimefunItem.getByItem((ItemStack)event.getItem().getItemStack());
            if (item != null) {
                Debug.debug("Insert player pickup item log");
                LogDao.insertLog(player.getName(), TimeUtil.now(), Action.PICKUP_ITEM.getKey(), LogEntry.getStringBlockLocation(player.getLocation()), item.getId());
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerDropItem(@NotNull PlayerDropItemEvent event) {
        SlimefunItem item = SlimefunItem.getByItem((ItemStack)event.getItemDrop().getItemStack());
        if (item != null) {
            Debug.debug("Insert player drop item log");
            Player player = event.getPlayer();
            LogDao.insertLog(player.getName(), TimeUtil.now(), Action.DROP_ITEM.getKey(), LogEntry.getStringBlockLocation(player.getLocation()), item.getId());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerInteract(@NotNull PlayerInteractEvent event) {
        SlimefunItem item = SlimefunItem.getByItem((ItemStack)event.getItem());
        if (item != null) {
            Debug.debug("Insert player interact item log");
            Player player = event.getPlayer();
            Block block = event.getClickedBlock();
            if (block == null) {
                LogDao.insertLog(player.getName(), TimeUtil.now(), Action.INTERACT_ITEM.getKey(), LogEntry.getStringLocation(player.getLocation()), item.getId(), PlayerListener.getActionString(event));
            } else {
                LogDao.insertLog(player.getName(), TimeUtil.now(), Action.INTERACT_ITEM.getKey(), LogEntry.getStringBlockLocation(block.getRelative(event.getBlockFace()).getLocation()), item.getId(), PlayerListener.getActionString(event));
            }
        }
    }

    public static class ActionEntry {
        private final @NotNull org.bukkit.event.block.Action action;

        @Nullable
        public static ActionEntry fromString(@NotNull String str) {
            String[] parts = str.split(":");
            if (parts.length == 2 && parts[0].equals("iaction")) {
                try {
                    return new ActionEntry(org.bukkit.event.block.Action.valueOf((String)parts[1]));
                }
                catch (Exception e) {
                    Debug.debug("Invalid action string: " + str);
                }
            }
            return null;
        }

        @NotNull
        public String toString() {
            return "iaction:" + this.action.name();
        }

        @Generated
        public ActionEntry(@NotNull org.bukkit.event.block.Action action) {
            this.action = action;
        }

        @Generated
        public @NotNull org.bukkit.event.block.Action getAction() {
            return this.action;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ActionEntry)) {
                return false;
            }
            ActionEntry other = (ActionEntry)o;
            if (!other.canEqual(this)) {
                return false;
            }
            org.bukkit.event.block.Action this$action = this.getAction();
            org.bukkit.event.block.Action other$action = other.getAction();
            return !(this$action == null ? other$action != null : !this$action.equals(other$action));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ActionEntry;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            org.bukkit.event.block.Action $action = this.getAction();
            result = result * 59 + ($action == null ? 43 : $action.hashCode());
            return result;
        }
    }
}

