/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.slimefuncoreprotect.core.commands.subcommands;

import com.balugaq.slimefuncoreprotect.api.logs.LogEntry;
import com.balugaq.slimefuncoreprotect.api.utils.Lang;
import com.balugaq.slimefuncoreprotect.core.commands.SubCommand;
import com.balugaq.slimefuncoreprotect.core.managers.CommandManager;
import java.util.List;
import java.util.Map;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PageCommand
extends SubCommand {
    public PageCommand(@NotNull JavaPlugin plugin) {
        super(plugin);
    }

    @Override
    @NotNull
    public String getName() {
        return "page";
    }

    @Override
    public boolean canCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull @NotNull String @NotNull [] args) {
        if (args.length == 0) {
            return false;
        }
        return this.getName().equalsIgnoreCase(args[0]);
    }

    @Override
    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull @NotNull String @NotNull [] args) {
        int page;
        if (args.length < 2) {
            sender.sendMessage(Lang.getMessage("commands.page.page-number-required"));
            return false;
        }
        try {
            page = Integer.parseInt(args[1]);
        }
        catch (NumberFormatException e) {
            sender.sendMessage(Lang.getMessage("commands.page.invalid-page-number", "page", args[1]));
            return false;
        }
        Map<CommandSender, Integer> pages = CommandManager.getPages();
        if (!pages.containsKey(sender)) {
            sender.sendMessage(Lang.getMessage("commands.page.no-pages-found"));
            return false;
        }
        if (CommandManager.getLastLookup().containsKey(sender)) {
            List<LogEntry> entries = CommandManager.getLastLookup().get(sender);
            pages.put(sender, Math.max(1, Math.min(page, CommandManager.getMaxPage(entries))));
            CommandManager.lookup(sender, entries, null);
        }
        return true;
    }

    @Override
    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        return null;
    }
}

