/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.slimefuncoreprotect.api.utils;

import com.balugaq.slimefuncoreprotect.api.utils.Lang;
import com.balugaq.slimefuncoreprotect.implementation.SlimefunCoreProtect;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Debug {
    private static final String debugPrefix = Lang.getMessage("debug-prefix");
    private static JavaPlugin plugin;

    public static void debug(Object ... objects) {
        StringBuilder sb = new StringBuilder();
        for (Object obj : objects) {
            if (obj == null) {
                sb.append("null");
                continue;
            }
            sb.append(obj);
        }
        Debug.debug(sb.toString());
    }

    public static void debug(@NotNull Throwable e) {
        Debug.debug(e.getMessage());
        e.printStackTrace();
    }

    public static void debug(@NotNull Object object) {
        Debug.debug(object.toString());
    }

    public static void debug(String ... messages) {
        for (String message : messages) {
            Debug.debug(message);
        }
    }

    public static void debug(String message) {
        if (SlimefunCoreProtect.getInstance().getConfigManager().isDebug()) {
            Debug.log(debugPrefix + message);
        }
    }

    public static void sendMessage(@NotNull Player player, Object ... objects) {
        StringBuilder sb = new StringBuilder();
        for (Object obj : objects) {
            if (obj == null) {
                sb.append("null");
                continue;
            }
            sb.append(obj);
        }
        Debug.sendMessage(player, sb.toString());
    }

    public static void sendMessage(@NotNull Player player, @Nullable Object object) {
        if (object == null) {
            Debug.sendMessage(player, "null");
            return;
        }
        Debug.sendMessage(player, object.toString());
    }

    public static void sendMessages(@NotNull Player player, String ... messages) {
        for (String message : messages) {
            Debug.sendMessage(player, message);
        }
    }

    public static void sendMessage(@NotNull Player player, String message) {
        Debug.init();
        player.sendMessage("[" + plugin.getLogger().getName() + "]" + message);
    }

    public static void stackTraceManually() {
        if (SlimefunCoreProtect.getInstance().getConfigManager().isDebug()) {
            try {
                throw new Error();
            }
            catch (Throwable e) {
                Debug.log(e);
            }
        }
    }

    public static void log(Object ... object) {
        StringBuilder sb = new StringBuilder();
        for (Object obj : object) {
            if (obj == null) {
                sb.append("null");
                continue;
            }
            sb.append(obj);
        }
        Debug.log(sb.toString());
    }

    public static void log(@NotNull Object object) {
        Debug.log(object.toString());
    }

    public static void log(String ... messages) {
        for (String message : messages) {
            Debug.log(message);
        }
    }

    public static void log(@NotNull String message) {
        Debug.init();
        plugin.getServer().getConsoleSender().sendMessage("[" + SlimefunCoreProtect.getInstance().getName() + "] " + ChatColor.translateAlternateColorCodes((char)'&', (String)message));
    }

    public static void log(@NotNull Throwable e) {
        e.printStackTrace();
    }

    public static void log() {
        Debug.log("");
    }

    public static void init() {
        if (plugin == null) {
            plugin = SlimefunCoreProtect.getInstance();
        }
    }
}

