/*
 * Decompiled with CFR 0.152.
 */
package com.balugaq.slimefuncoreprotect.api;

import com.balugaq.slimefuncoreprotect.api.ConsoleQueryUser;
import com.balugaq.slimefuncoreprotect.api.PlayerQueryUser;
import java.util.Map;
import java.util.WeakHashMap;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class QueryUser {
    private static final Map<QueryUser, Long> lastQueryTime = new WeakHashMap<QueryUser, Long>();

    public static void updateLastQueryTime(QueryUser user) {
        lastQueryTime.put(user, System.currentTimeMillis());
    }

    public static long getLastQueryTime(QueryUser user) {
        return lastQueryTime.getOrDefault(user, 0L);
    }

    public static void clearLastQueryTime(QueryUser user) {
        lastQueryTime.remove(user);
    }

    public static void clearAllLastQueryTime() {
        lastQueryTime.clear();
    }

    public static boolean isOutdated(QueryUser user, long timeout) {
        return System.currentTimeMillis() - QueryUser.getLastQueryTime(user) > timeout;
    }

    @Contract(value="null -> null; !null -> new")
    public static QueryUser create(@Nullable ConsoleCommandSender console) {
        if (console == null) {
            return null;
        }
        return new ConsoleQueryUser(console);
    }

    @Contract(value="null -> null; !null -> new")
    public static QueryUser create(@Nullable Player player) {
        if (player == null) {
            return null;
        }
        return new PlayerQueryUser(player);
    }

    @Nullable
    public static QueryUser create(Object object) {
        if (object instanceof ConsoleCommandSender) {
            ConsoleCommandSender console = (ConsoleCommandSender)object;
            return QueryUser.create(console);
        }
        if (object instanceof Player) {
            Player player = (Player)object;
            return QueryUser.create(player);
        }
        return null;
    }

    @NotNull
    public abstract String getUsername();

    public abstract boolean isOnline();

    public abstract boolean isOp();

    public abstract boolean hasPermission(String var1);

    public abstract void sendMessage(String var1);
}

