/*
 * Decompiled with CFR 0.152.
 */
package me.char321.sfadvancements.vanilla;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import me.char321.sfadvancements.SFAdvancements;
import me.char321.sfadvancements.api.AdvancementGroup;
import me.char321.sfadvancements.api.criteria.Criterion;
import me.char321.sfadvancements.libs.advancementapi.AdvancementManager;
import me.char321.sfadvancements.libs.advancementapi.display.FrameType;
import me.char321.sfadvancements.libs.advancementapi.display.Icon;
import me.char321.sfadvancements.libs.advancementapi.trigger.TriggerType;
import me.char321.sfadvancements.util.Utils;
import me.char321.sfadvancements.vanilla.AdvancementListener;
import me.char321.sfadvancements.vanilla.PlayerJoinListener;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.advancement.Advancement;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class VanillaHook {
    private AdvancementManager vanillaManager;
    private boolean initialized = false;

    public void init() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        this.vanillaManager = new AdvancementManager((Plugin)SFAdvancements.instance());
        Utils.listen(new PlayerJoinListener());
        Utils.listen(new AdvancementListener());
        this.reload();
    }

    public void reload() {
        if (!this.initialized) {
            this.init();
        }
        this.vanillaManager.clearAdvancements();
        VanillaHook.registerGroups(this.vanillaManager);
        VanillaHook.registerAdvancements(this.vanillaManager);
        this.vanillaManager.createAll(true);
        for (Player p : Bukkit.getOnlinePlayers()) {
            this.syncProgress(p);
        }
    }

    private static void registerGroups(AdvancementManager manager) {
        for (AdvancementGroup group : SFAdvancements.getRegistry().getAdvancementGroups()) {
            manager.register(context -> {
                me.char321.sfadvancements.libs.advancementapi.Advancement vadvancement = new me.char321.sfadvancements.libs.advancementapi.Advancement(Utils.keyOf(group.getId()));
                vadvancement.setDisplay(display -> {
                    ItemStack item = group.getDisplayItem();
                    String background = group.getBackground();
                    ItemMeta meta = item.getItemMeta();
                    display.setTitle(meta.getDisplayName());
                    ArrayList lore = meta.getLore();
                    if (lore == null) {
                        lore = new ArrayList();
                    }
                    display.setDescription(String.join((CharSequence)"\n", lore));
                    display.setIcon(new Icon(item));
                    display.setFrame(FrameType.valueOf(group.getFrameType()));
                    display.setBackground(NamespacedKey.minecraft((String)("textures/block/" + background.toLowerCase() + ".png")));
                    display.setAnnounce(false);
                });
                vadvancement.addCriteria("impossible", TriggerType.IMPOSSIBLE, a -> {});
                return vadvancement;
            });
        }
    }

    private static void registerAdvancements(AdvancementManager manager) {
        for (Map.Entry<NamespacedKey, me.char321.sfadvancements.api.Advancement> entry : SFAdvancements.getRegistry().getAdvancements().entrySet()) {
            VanillaHook.registerAdvancement(manager, entry.getValue());
        }
    }

    private static void registerAdvancement(AdvancementManager manager, me.char321.sfadvancements.api.Advancement advancement) {
        me.char321.sfadvancements.api.Advancement parent;
        if (manager == null) {
            return;
        }
        if (advancement == null) {
            return;
        }
        if (manager.getAdvancements().stream().anyMatch(vadv -> vadv.getKey().equals((Object)advancement.getKey()))) {
            return;
        }
        if (manager.getAdvancements().stream().noneMatch(vadv -> vadv.getKey().equals((Object)advancement.getParent())) && (parent = Utils.fromKey(advancement.getParent())) != null) {
            VanillaHook.registerAdvancement(manager, parent);
        }
        manager.register(context -> {
            me.char321.sfadvancements.libs.advancementapi.Advancement vadvancement = new me.char321.sfadvancements.libs.advancementapi.Advancement(advancement.getKey());
            vadvancement.setDisplay(display -> {
                ItemStack item = advancement.getDisplay();
                ItemMeta meta = item.getItemMeta();
                Object title = meta.hasDisplayName() ? new TextComponent(meta.getDisplayName()) : Utils.getItemName(item);
                String description = VanillaHook.getDescriptionFor(meta.getLore(), advancement);
                display.setTitle((BaseComponent)title);
                display.setDescription(description);
                display.setIcon(new Icon(item));
                display.setFrame(FrameType.valueOf(advancement.getFrameType()));
                display.setHidden(advancement.isHidden());
                display.setAnnounce(false);
            });
            vadvancement.setParent(advancement.getParent());
            vadvancement.addCriteria("impossible", TriggerType.IMPOSSIBLE, a -> {});
            return vadvancement;
        });
    }

    private static String getDescriptionFor(List<String> lore, me.char321.sfadvancements.api.Advancement adv) {
        lore = lore == null ? new ArrayList<String>() : new ArrayList<String>(lore);
        for (int i = lore.size() - 1; i >= 0; --i) {
            if (!"%criteria%".equals(lore.get(i))) continue;
            lore.remove(i);
            lore.addAll(i, VanillaHook.getCriteriaLore(adv));
            return String.join((CharSequence)"\n", lore);
        }
        return String.join((CharSequence)"\n", lore);
    }

    private static List<String> getCriteriaLore(me.char321.sfadvancements.api.Advancement adv) {
        ArrayList<String> res = new ArrayList<String>();
        for (Criterion criterion : adv.getCriteria()) {
            res.add("\u00a77" + criterion.getName());
        }
        return res;
    }

    public void syncProgress(Player p) {
        for (AdvancementGroup group : SFAdvancements.getRegistry().getAdvancementGroups()) {
            this.complete(p, Utils.keyOf(group.getId()));
        }
        for (me.char321.sfadvancements.api.Advancement adv : SFAdvancements.getRegistry().getAdvancements().values()) {
            if (SFAdvancements.getAdvManager().isCompleted(p, adv)) {
                this.complete(p, adv.getKey());
                continue;
            }
            this.revoke(p, adv.getKey());
        }
    }

    public void complete(Player p, NamespacedKey key) {
        Advancement advancement = Bukkit.getAdvancement((NamespacedKey)key);
        if (advancement == null) {
            SFAdvancements.warn("Tried to complete unregistered advancement " + key);
            return;
        }
        Utils.runSync(() -> p.getAdvancementProgress(advancement).awardCriteria("impossible"));
    }

    public void revoke(Player p, NamespacedKey key) {
        Advancement advancement = Bukkit.getAdvancement((NamespacedKey)key);
        if (advancement == null) {
            SFAdvancements.warn("Tried to revoke unregistered advancement " + key);
            return;
        }
        Utils.runSync(() -> p.getAdvancementProgress(advancement).revokeCriteria("impossible"));
    }
}

