/*
 * Decompiled with CFR 0.152.
 */
package me.char321.sfadvancements.core.criteria.completer;

import io.github.thebusybiscuit.slimefun4.api.events.MultiBlockInteractEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import me.char321.sfadvancements.SFAdvancements;
import me.char321.sfadvancements.api.criteria.Criterion;
import me.char321.sfadvancements.api.criteria.MultiBlockCriterion;
import me.char321.sfadvancements.core.criteria.completer.CriterionCompleter;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class MultiBlockCriterionCompleter
implements CriterionCompleter,
Listener {
    private final Map<String, Set<MultiBlockCriterion>> criteria = new HashMap<String, Set<MultiBlockCriterion>>();

    public MultiBlockCriterionCompleter() {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)SFAdvancements.instance());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onMultiBlock(MultiBlockInteractEvent e) {
        String machineid = e.getMultiBlock().getSlimefunItem().getId();
        if (!this.criteria.containsKey(machineid)) {
            return;
        }
        for (MultiBlockCriterion criterion : this.criteria.get(machineid)) {
            criterion.perform(e.getPlayer());
        }
    }

    @Override
    public void register(Criterion criterion) {
        if (!this.getCriterionClass().isInstance(criterion)) {
            throw new IllegalArgumentException("criterion must be a " + this.getCriterionClass().getName());
        }
        MultiBlockCriterion criterion1 = (MultiBlockCriterion)criterion;
        String machine = criterion1.getMachineId();
        this.criteria.computeIfAbsent(machine, k -> new HashSet()).add(criterion1);
    }

    @Override
    public Class<? extends Criterion> getCriterionClass() {
        return MultiBlockCriterion.class;
    }

    @Override
    public void reload() {
        this.criteria.clear();
    }
}

