/*
 * Decompiled with CFR 0.152.
 */
package me.char321.sfadvancements.libs.advancementapi;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import me.char321.sfadvancements.libs.advancementapi.Advancement;
import me.char321.sfadvancements.libs.advancementapi.AdvancementCreator;
import me.char321.sfadvancements.libs.advancementapi.Context;
import me.char321.sfadvancements.libs.advancementapi.serialization.ObjectSerializer;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.NamespacedKey;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AdvancementManager {
    private final Plugin plugin;
    private final ObjectSerializer serializer = new ObjectSerializer();
    private final Map<NamespacedKey, Advancement> advancements = new LinkedHashMap<NamespacedKey, Advancement>();

    public AdvancementManager(@NotNull Plugin plugin) {
        Preconditions.checkNotNull((Object)plugin);
        this.plugin = plugin;
    }

    @NotNull
    public ImmutableList<Advancement> getAdvancements() {
        return ImmutableList.copyOf(this.advancements.values());
    }

    @Nullable
    public Advancement getAdvancement(@NotNull String id) {
        Preconditions.checkNotNull((Object)id);
        return this.advancements.get(new NamespacedKey(this.plugin, id));
    }

    public void register(@NotNull AdvancementCreator creator) {
        Preconditions.checkNotNull((Object)creator);
        Advancement advancement = creator.create(new Context(this.plugin, this.advancements));
        this.register(advancement);
    }

    public void register(@NotNull Advancement advancement) {
        Preconditions.checkNotNull((Object)advancement);
        NamespacedKey key = advancement.getKey();
        if (!key.getNamespace().equals(this.plugin.getName().toLowerCase(Locale.ROOT))) {
            throw new IllegalArgumentException("key namespace must be from plugin");
        }
        this.advancements.put(key, advancement);
    }

    public void clearAdvancements() {
        this.advancements.clear();
    }

    public void createAll(boolean clean) {
        ArrayList recipes = new ArrayList();
        Bukkit.recipeIterator().forEachRemaining(recipes::add);
        if (clean) {
            this.plugin.getLogger().info("[AdvancementAPI] Cleaning previously generated advancements");
            ArrayList toRemove = new ArrayList();
            Iterator iterator = Bukkit.advancementIterator();
            while (iterator.hasNext()) {
                org.bukkit.advancement.Advancement adv = (org.bukkit.advancement.Advancement)iterator.next();
                if (!adv.getKey().getNamespace().equals(this.plugin.getName().toLowerCase(Locale.ROOT))) continue;
                toRemove.add(adv.getKey());
            }
            Iterator iterator2 = toRemove.iterator();
            while (iterator2.hasNext()) {
                NamespacedKey advancement = (NamespacedKey)iterator2.next();
                if (Bukkit.getAdvancement((NamespacedKey)advancement) == null) continue;
                Bukkit.getUnsafe().removeAdvancement(advancement);
            }
            Bukkit.reloadData();
        }
        this.plugin.getLogger().info("[AdvancementAPI] Generating advancements");
        for (Advancement advancement : this.advancements.values()) {
            if (Bukkit.getAdvancement((NamespacedKey)advancement.getKey()) != null) continue;
            Bukkit.getUnsafe().loadAdvancement(advancement.getKey(), this.serializer.serialize(advancement));
        }
        Bukkit.reloadData();
        HashSet currentRecipes = new HashSet();
        Bukkit.recipeIterator().forEachRemaining(recipe -> currentRecipes.add(((Keyed)recipe).getKey()));
        recipes.stream().filter(recipe -> !currentRecipes.contains(((Keyed)recipe).getKey())).forEach(Bukkit::addRecipe);
    }
}

