/*
 * Decompiled with CFR 0.152.
 */
package me.char321.sfadvancements.api;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import me.char321.sfadvancements.SFAdvancements;
import me.char321.sfadvancements.api.Advancement;
import me.char321.sfadvancements.api.AdvancementGroup;
import me.char321.sfadvancements.api.criteria.CriteriaTypes;
import me.char321.sfadvancements.api.criteria.Criterion;
import me.char321.sfadvancements.api.reward.Reward;
import me.char321.sfadvancements.util.ConfigUtils;
import me.char321.sfadvancements.util.Utils;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class AdvancementBuilder {
    private NamespacedKey key;
    private NamespacedKey parent;
    private AdvancementGroup group;
    private ItemStack display;
    private String frame;
    private String name;
    private boolean hidden;
    private List<Criterion> criteria = new ArrayList<Criterion>();
    private List<Reward> rewards = new ArrayList<Reward>();

    public static AdvancementBuilder loadFromConfig(String key, ConfigurationSection config) {
        NamespacedKey parentKey;
        AdvancementBuilder builder = new AdvancementBuilder();
        builder.key(Utils.keyOf(key));
        String groupName = config.getString("group");
        AdvancementGroup group = AdvancementBuilder.getGroup(groupName);
        if (group == null) {
            SFAdvancements.warn("unknown group " + groupName + " for advancement " + key);
            return null;
        }
        builder.group(group);
        String parent = config.getString("parent");
        if (parent == null) {
            parent = groupName;
        }
        builder.parent((parentKey = NamespacedKey.fromString((String)parent, (Plugin)SFAdvancements.instance())) != null ? parentKey : Utils.keyOf(parent));
        ItemStack display = ConfigUtils.getItem(config, "display");
        if (display == null) {
            SFAdvancements.warn("invalid display for advancement " + key);
            return null;
        }
        builder.display(display);
        String frame = config.getString("frame_type");
        if (frame == null) {
            frame = "TASK";
        }
        builder.frame(frame);
        String advname = config.getString("name");
        if (advname == null) {
            advname = key;
        }
        builder.name(advname);
        builder.hidden(config.getBoolean("hidden"));
        ConfigurationSection cripath = config.getConfigurationSection("criteria");
        if (cripath == null) {
            SFAdvancements.warn("criteria must be specified for advancement " + key);
            return null;
        }
        ArrayList<Criterion> criteria = new ArrayList<Criterion>();
        for (String id : cripath.getKeys(false)) {
            Criterion criterion = CriteriaTypes.loadFromConfig(id, cripath.getConfigurationSection(id));
            if (criterion != null) {
                criteria.add(criterion);
                continue;
            }
            return null;
        }
        builder.criteria(criteria);
        ArrayList<Reward> rewards = new ArrayList<Reward>();
        ConfigurationSection rewardSection = config.getConfigurationSection("rewards");
        if (rewardSection != null) {
            for (String command : rewardSection.getStringList("commands")) {
                rewards.add(p -> Utils.runSync(() -> Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getServer().getConsoleSender(), command.replace("%p%", p.getName()))));
            }
        }
        builder.rewards(rewards);
        return builder;
    }

    @Nullable
    public static AdvancementGroup getGroup(String name) {
        for (AdvancementGroup advgroup : SFAdvancements.getRegistry().getAdvancementGroups()) {
            if (!advgroup.getId().equals(name)) continue;
            return advgroup;
        }
        return null;
    }

    public AdvancementBuilder key(NamespacedKey key) {
        this.key = key;
        return this;
    }

    public AdvancementBuilder parent(NamespacedKey parent) {
        this.parent = parent;
        return this;
    }

    public AdvancementBuilder group(String group) {
        this.group = AdvancementBuilder.getGroup(group);
        if (this.group == null) {
            SFAdvancements.warn("unknown group: " + group);
        }
        return this;
    }

    public AdvancementBuilder group(AdvancementGroup group) {
        this.group = group;
        return this;
    }

    public AdvancementBuilder display(ItemStack display) {
        this.display = display;
        return this;
    }

    public AdvancementBuilder frame(String frame) {
        this.frame = frame;
        return this;
    }

    public AdvancementBuilder name(String name) {
        this.name = name;
        return this;
    }

    public AdvancementBuilder hidden(boolean hidden) {
        this.hidden = hidden;
        return this;
    }

    public AdvancementBuilder criteria(List<Criterion> criteria) {
        this.criteria.addAll(criteria);
        return this;
    }

    public AdvancementBuilder rewards(List<Reward> rewards) {
        this.rewards.addAll(rewards);
        return this;
    }

    public void register() {
        for (Criterion criterion : this.criteria) {
            criterion.setAdvancement(this.key);
            criterion.register();
        }
        Advancement adv = new Advancement(this.key, this.parent, this.group, this.display, this.frame, this.name, this.hidden, this.criteria.toArray(new Criterion[0]), this.rewards.toArray(new Reward[0]));
        adv.register();
    }
}

