/*
 * Decompiled with CFR 0.152.
 */
package me.char321.sfadvancements.core.criteria.completer;

import io.github.thebusybiscuit.slimefun4.api.events.MultiBlockCraftEvent;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import me.char321.sfadvancements.SFAdvancements;
import me.char321.sfadvancements.api.criteria.Criterion;
import me.char321.sfadvancements.api.criteria.MultiBlockCraftCriterion;
import me.char321.sfadvancements.core.criteria.completer.CriterionCompleter;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class MultiBlockCraftCriterionCompleter
implements CriterionCompleter,
Listener {
    private final Map<Material, Set<MultiBlockCraftCriterion>> criteria = new EnumMap<Material, Set<MultiBlockCraftCriterion>>(Material.class);
    private final Set<MultiBlockCraftCriterion> nonMaterialCriteria = new HashSet<MultiBlockCraftCriterion>();

    public MultiBlockCraftCriterionCompleter() {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)SFAdvancements.instance());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onMultiBlockCraft(MultiBlockCraftEvent e) {
        this.performCriteria(e.getPlayer(), e.getMachine().getId(), e.getOutput());
    }

    private void performCriteria(Player player, String machineId, ItemStack output) {
        for (MultiBlockCraftCriterion criterion : this.nonMaterialCriteria) {
            String machineId1 = criterion.getMachineId();
            if (machineId1 != null && !machineId1.equals(machineId)) continue;
            criterion.perform(player);
        }
        Set<MultiBlockCraftCriterion> allcriteria = this.criteria.get(output.getType());
        if (allcriteria == null) {
            return;
        }
        for (MultiBlockCraftCriterion criterion : allcriteria) {
            String machineId1 = criterion.getMachineId();
            if (machineId1 != null && !machineId1.equals(machineId) || !SlimefunUtils.isItemSimilar((ItemStack)output, (ItemStack)criterion.getItem(), (boolean)false, (boolean)false)) continue;
            criterion.perform(player);
        }
    }

    @Override
    public void register(Criterion criterion) {
        if (!this.getCriterionClass().isInstance(criterion)) {
            throw new IllegalArgumentException("criterion must be an " + this.getCriterionClass().getName());
        }
        MultiBlockCraftCriterion criterion1 = (MultiBlockCraftCriterion)criterion;
        ItemStack item = criterion1.getItem();
        if (item == null) {
            this.nonMaterialCriteria.add(criterion1);
        } else {
            this.criteria.computeIfAbsent(item.getType(), k -> new HashSet()).add(criterion1);
        }
    }

    @Override
    public Class<? extends Criterion> getCriterionClass() {
        return MultiBlockCraftCriterion.class;
    }

    @Override
    public void reload() {
        this.criteria.clear();
        this.nonMaterialCriteria.clear();
    }
}

