/*
 * Decompiled with CFR 0.152.
 */
package me.char321.sfadvancements.libs.dough.blocks;

import java.lang.ref.WeakReference;
import javax.annotation.Nonnull;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;

public final class ChunkPosition {
    private final WeakReference<World> world;
    private final long position;

    public ChunkPosition(@Nonnull World world, long position) {
        this.world = new WeakReference<World>(world);
        this.position = position;
    }

    public ChunkPosition(@Nonnull World world, int x, int z) {
        this.world = new WeakReference<World>(world);
        this.position = ChunkPosition.getAsLong(x, z);
    }

    public ChunkPosition(@Nonnull Chunk chunk) {
        this(chunk.getWorld(), chunk.getX(), chunk.getZ());
    }

    public ChunkPosition(@Nonnull Location l) {
        this(l.getWorld(), l.getBlockX() >> 4, l.getBlockZ() >> 4);
    }

    public World getWorld() {
        World ref = (World)this.world.get();
        if (ref == null) {
            throw new IllegalStateException("The reference of this BlockPositions world has been cleared");
        }
        return ref;
    }

    public boolean isLoaded() {
        World ref = (World)this.world.get();
        if (ref == null) {
            return false;
        }
        return ref.isChunkLoaded(this.getX(), this.getZ());
    }

    public long getPosition() {
        return this.position;
    }

    public int getX() {
        return (int)(this.position >> 32);
    }

    public int getZ() {
        return (int)this.position;
    }

    public Chunk getChunk() {
        World ref = (World)this.world.get();
        if (ref == null) {
            throw new IllegalStateException("Cannot get Chunk when the world isn't loaded");
        }
        return ref.getChunkAt(this.getX(), this.getZ());
    }

    public static long getAsLong(int x, int z) {
        return (long)x << 32 | (long)z & 0xFFFFFFFFL;
    }

    public boolean equals(Object o) {
        if (o instanceof ChunkPosition) {
            ChunkPosition pos = (ChunkPosition)o;
            if (pos.world.get() == null) {
                return false;
            }
            return this.getWorld().getUID().equals(pos.getWorld().getUID()) && this.position == pos.position;
        }
        return false;
    }

    public int hashCode() {
        int prime = 31;
        World ref = (World)this.world.get();
        int result = 0;
        result += 31 * (ref == null ? 0 : ref.hashCode());
        return result += 31 * Long.hashCode(this.position);
    }

    public String toString() {
        World w = (World)this.world.get();
        String worldName = w != null ? w.getName() : "<no reference>";
        return String.format("ChunkPosition(world=%s, x=%d, z=%d, position=%d)", worldName, this.getX(), this.getZ(), this.getPosition());
    }
}

