/*
 * Decompiled with CFR 0.152.
 */
package me.char321.sfadvancements.api;

import java.util.Objects;
import javax.annotation.Nullable;
import me.char321.sfadvancements.SFAdvancements;
import me.char321.sfadvancements.api.AdvancementGroup;
import me.char321.sfadvancements.api.criteria.Criterion;
import me.char321.sfadvancements.api.reward.Reward;
import me.char321.sfadvancements.util.Utils;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.chat.hover.content.Content;
import net.md_5.bungee.api.chat.hover.content.Text;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class Advancement {
    private final NamespacedKey key;
    private final NamespacedKey parent;
    private final AdvancementGroup group;
    private final ItemStack display;
    private final String frameType;
    private final String name;
    private final boolean hidden;
    private final Criterion[] criteria;
    private final Reward[] rewards;

    public Advancement(NamespacedKey key, @Nullable NamespacedKey parent, AdvancementGroup group, ItemStack display, String name, boolean hidden, Criterion[] criteria, Reward[] rewards) {
        this(key, parent, group, display, "GOAL", name, hidden, criteria, rewards);
    }

    public Advancement(NamespacedKey key, @Nullable NamespacedKey parent, AdvancementGroup group, ItemStack display, String frameType, String name, boolean hidden, Criterion[] criteria, Reward[] rewards) {
        this.key = key;
        if (parent == null) {
            parent = Utils.keyOf(group.getId());
        }
        this.parent = parent;
        this.group = group;
        this.display = display;
        this.frameType = frameType;
        this.name = ChatColor.translateAlternateColorCodes((char)'&', (String)name);
        this.hidden = hidden;
        this.criteria = criteria;
        this.rewards = rewards;
    }

    public NamespacedKey getKey() {
        return this.key;
    }

    public NamespacedKey getParent() {
        return this.parent;
    }

    public AdvancementGroup getGroup() {
        return this.group;
    }

    public ItemStack getDisplay() {
        return this.display;
    }

    public String getFrameType() {
        return this.frameType;
    }

    public String getName() {
        return this.name;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public Criterion[] getCriteria() {
        return this.criteria;
    }

    public Reward[] getRewards() {
        return this.rewards;
    }

    @Nullable
    public Criterion getCriterion(String id) {
        for (Criterion criterion : this.criteria) {
            if (!criterion.getId().equals(id)) continue;
            return criterion;
        }
        return null;
    }

    public String getDescription() {
        ItemMeta im;
        String res = this.getName().replaceAll("[\\[\\]]", "");
        res = res + "\n";
        if (this.display.hasItemMeta() && (im = this.display.getItemMeta()) != null && im.hasLore()) {
            res = res + String.join((CharSequence)" ", im.getLore());
        }
        return res;
    }

    public void register() {
        this.group.addAdvancement(this);
        SFAdvancements.getRegistry().getAdvancements().put(this.key, this);
    }

    public void complete(Player p) {
        for (Criterion criterion : this.criteria) {
            criterion.complete(p);
        }
    }

    public void onComplete(Player p) {
        for (Reward reward : this.rewards) {
            reward.give(p);
        }
        if (SFAdvancements.getMainConfig().getBoolean("use-advancements-api")) {
            SFAdvancements.getVanillaHook().complete(p, this.getKey());
        }
        if (SFAdvancements.getMainConfig().getConfiguration().getBoolean("announce-advancements", true)) {
            this.broadcastMessage(p);
        }
    }

    public void revoke(Player p) {
        if (SFAdvancements.getMainConfig().getBoolean("use-advancements-api")) {
            SFAdvancements.getVanillaHook().revoke(p, this.getKey());
        }
    }

    private void broadcastMessage(Player p) {
        TextComponent component = new TextComponent();
        component.addExtra(p.getName() + " has made the advancement ");
        TextComponent sub = new TextComponent(this.getName());
        sub.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new Content[]{new Text(this.getDescription())}));
        component.addExtra((BaseComponent)sub);
        Bukkit.spigot().broadcast((BaseComponent)component);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Advancement that = (Advancement)o;
        return this.key.equals((Object)that.key);
    }

    public int hashCode() {
        return Objects.hash(this.key);
    }
}

