/*
 * Decompiled with CFR 0.152.
 */
package me.char321.sfadvancements.core.gui;

import io.github.thebusybiscuit.slimefun4.api.player.PlayerProfile;
import io.github.thebusybiscuit.slimefun4.core.guide.SlimefunGuide;
import io.github.thebusybiscuit.slimefun4.core.guide.SlimefunGuideMode;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import me.char321.sfadvancements.SFAdvancements;
import me.char321.sfadvancements.api.Advancement;
import me.char321.sfadvancements.api.AdvancementGroup;
import me.char321.sfadvancements.api.criteria.Criterion;
import me.char321.sfadvancements.core.gui.MenuItems;
import me.char321.sfadvancements.core.registry.AdvancementsRegistry;
import me.char321.sfadvancements.libs.dough.items.CustomItemStack;
import me.char321.sfadvancements.util.Utils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class OpenGUI {
    private final Inventory inventory;
    private final AdvancementsRegistry registry = SFAdvancements.getRegistry();
    private final UUID playerUUID;
    private int page = 1;
    private int groupIndex = 0;
    private int scroll = 0;

    public OpenGUI(Player player) {
        this(player.getUniqueId());
    }

    public OpenGUI(UUID playerUUID) {
        this.inventory = Bukkit.createInventory(null, (int)54, (String)(ChatColor.BLUE + "Advancements"));
        this.playerUUID = playerUUID;
        this.refresh();
    }

    public Inventory getInventory() {
        this.refresh();
        return this.inventory;
    }

    public void click(Player player, int slot) {
        AdvancementGroup group;
        int size;
        int maxScroll;
        if (slot == 0) {
            PlayerProfile.find((OfflinePlayer)player).ifPresent(profile -> SlimefunGuide.openMainMenu((PlayerProfile)profile, (SlimefunGuideMode)SlimefunGuideMode.SURVIVAL_MODE, (int)profile.getGuideHistory().getMainMenuPage()));
        } else if (slot == 1 && this.page > 1) {
            --this.page;
        } else if (slot == 7) {
            int maxPage = (this.registry.getAdvancementGroups().size() - 1) / 5 + 1;
            if (this.page + 1 <= maxPage) {
                ++this.page;
            }
        } else if (slot > 1 && slot < 7) {
            int possibleIndex = 5 * (this.page - 1) + (slot - 2);
            if (this.registry.getAdvancementGroups().size() > possibleIndex) {
                this.groupIndex = possibleIndex;
                this.scroll = 0;
            }
        } else if (slot == 17 && this.scroll > 0) {
            --this.scroll;
        } else if (slot == 53 && this.scroll + 1 <= (maxScroll = ((size = (group = this.registry.getAdvancementGroups().get(this.groupIndex)).getVisibleAdvancements(this.playerUUID).size()) - 1) / 8 - 4)) {
            ++this.scroll;
        }
        this.refresh();
    }

    public void refresh() {
        this.refreshBackButton();
        this.refreshStats();
        this.refreshArrows();
        this.refreshGroups();
        this.refreshScroll();
        this.refreshAdvancements();
    }

    private void refreshBackButton() {
        this.inventory.setItem(0, MenuItems.BACK_ITEM);
    }

    private void refreshStats() {
        ItemStack head = new ItemStack(Material.PLAYER_HEAD);
        SkullMeta meta = (SkullMeta)head.getItemMeta();
        meta.setOwningPlayer(Bukkit.getOfflinePlayer((UUID)this.playerUUID));
        meta.setDisplayName(ChatColor.YELLOW + "Stats");
        StringBuilder completedadvancements = new StringBuilder();
        completedadvancements.append(ChatColor.GRAY).append("Completed Advancements: ");
        int completed = SFAdvancements.getAdvManager().getProgress(this.playerUUID).getCompletedAdvancements().size();
        int total = SFAdvancements.getRegistry().getAdvancements().size();
        if (completed == total) {
            completedadvancements.append(ChatColor.YELLOW);
        } else {
            completedadvancements.append(ChatColor.WHITE);
        }
        completedadvancements.append(completed).append(ChatColor.GRAY).append("/").append(total);
        ArrayList<String> lore = new ArrayList<String>();
        lore.add(completedadvancements.toString());
        meta.setLore(lore);
        head.setItemMeta((ItemMeta)meta);
        this.inventory.setItem(8, head);
    }

    private void refreshArrows() {
        int maxPage = (this.registry.getAdvancementGroups().size() - 1) / 5 + 1;
        String pageLore = "&7(" + this.page + " / " + maxPage + ")";
        CustomItemStack leftArrow = this.page == 1 ? new CustomItemStack(Material.BLACK_STAINED_GLASS_PANE, "&7Previous Page", pageLore) : new CustomItemStack(Material.LIME_STAINED_GLASS_PANE, "&ePrevious Page", pageLore);
        this.inventory.setItem(1, (ItemStack)leftArrow);
        CustomItemStack rightArrow = this.page == maxPage ? new CustomItemStack(Material.BLACK_STAINED_GLASS_PANE, "&7Next Page", pageLore) : new CustomItemStack(Material.LIME_STAINED_GLASS_PANE, "&eNext Page", pageLore);
        this.inventory.setItem(7, (ItemStack)rightArrow);
    }

    private void refreshGroups() {
        for (int i = 0; i < 5; ++i) {
            ItemStack display;
            int slot = i + 2;
            int dispIndex = 5 * (this.page - 1) + i;
            if (this.registry.getAdvancementGroups().size() > dispIndex) {
                display = this.registry.getAdvancementGroups().get(dispIndex).getDisplayItem();
                if (dispIndex == this.groupIndex) {
                    display = Utils.makeShiny(display);
                }
            } else {
                display = MenuItems.GRAY;
            }
            this.inventory.setItem(slot, display);
        }
    }

    private void refreshScroll() {
        AdvancementGroup group = this.registry.getAdvancementGroups().get(this.groupIndex);
        this.inventory.setItem(26, MenuItems.YELLOW);
        this.inventory.setItem(35, MenuItems.YELLOW);
        this.inventory.setItem(44, MenuItems.YELLOW);
        Object scrollUp = this.scroll == 0 ? MenuItems.YELLOW : new CustomItemStack(Material.ARROW, "&eScroll Up", new String[0]);
        this.inventory.setItem(17, scrollUp);
        int size = group.getVisibleAdvancements(this.playerUUID).size();
        int maxScroll = (size - 1) / 8 - 4;
        Object scrollDown = this.scroll >= maxScroll ? MenuItems.YELLOW : new CustomItemStack(Material.ARROW, "&eScroll Down", new String[0]);
        this.inventory.setItem(53, scrollDown);
    }

    private void refreshAdvancements() {
        AdvancementGroup group = this.registry.getAdvancementGroups().get(this.groupIndex);
        List<Advancement> advancements = group.getVisibleAdvancements(this.playerUUID);
        for (int i = 0; i < 40; ++i) {
            int row = i / 8 + 1;
            int col = i % 8;
            int slot = row * 9 + col;
            int advindex = i + 8 * this.scroll;
            ItemStack display = null;
            if (advindex < advancements.size()) {
                Advancement adv = advancements.get(advindex);
                display = this.getDisplayFor(adv);
            }
            this.inventory.setItem(slot, display);
        }
    }

    private ItemStack getDisplayFor(Advancement adv) {
        ArrayList<String> lore;
        ItemStack display = adv.getDisplay().clone();
        ItemMeta displayim = display.getItemMeta();
        if (displayim == null) {
            throw new IllegalArgumentException("display item meta is null");
        }
        displayim.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
        if (SFAdvancements.getAdvManager().isCompleted(this.playerUUID, adv)) {
            Utils.makeShiny(displayim);
        }
        if ((lore = displayim.getLore()) == null) {
            lore = new ArrayList<String>();
        }
        boolean loreAdded = false;
        for (int i = lore.size() - 1; i >= 0; --i) {
            if (!"%criteria%".equals(lore.get(i))) continue;
            lore.remove(i);
            lore.addAll(i, this.getCriteriaLore(adv));
            loreAdded = true;
        }
        if (!loreAdded) {
            lore.addAll(this.getCriteriaLore(adv));
        }
        displayim.setLore(lore);
        display.setItemMeta(displayim);
        return display;
    }

    private List<String> getCriteriaLore(Advancement adv) {
        ArrayList<String> res = new ArrayList<String>();
        for (Criterion criterion : adv.getCriteria()) {
            int max;
            String criterionName = criterion.getName();
            int progress = SFAdvancements.getAdvManager().getCriterionProgress(this.playerUUID, criterion);
            boolean cridone = progress >= (max = criterion.getCount());
            res.add(ChatColor.GRAY + criterionName + ": " + (cridone ? ChatColor.YELLOW : ChatColor.WHITE) + progress + "/" + max);
        }
        return res;
    }
}

