/*
 * Decompiled with CFR 0.152.
 */
package me.char321.sfadvancements.libs.dough.skins;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.net.URL;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.char321.sfadvancements.libs.dough.reflection.ReflectionUtils;
import me.char321.sfadvancements.libs.dough.versions.MinecraftVersion;
import me.char321.sfadvancements.libs.dough.versions.UnknownServerVersionException;
import org.bukkit.Bukkit;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.profile.PlayerProfile;
import org.bukkit.profile.PlayerTextures;

final class CustomGameProfile
extends GameProfile {
    static final String PLAYER_NAME = "CS-CoreLib";
    static final String PROPERTY_KEY = "textures";
    private final URL skinUrl;

    CustomGameProfile(@Nonnull UUID uuid, @Nullable String texture, @Nonnull URL url) {
        super(uuid, PLAYER_NAME);
        this.skinUrl = url;
        if (texture != null) {
            this.getProperties().put((Object)PROPERTY_KEY, (Object)new Property(PROPERTY_KEY, texture));
        }
    }

    void apply(@Nonnull SkullMeta meta) throws NoSuchFieldException, IllegalAccessException, UnknownServerVersionException {
        ReflectionUtils.setFieldValue(meta, "profile", (Object)this);
        if (MinecraftVersion.get().isAtLeast(MinecraftVersion.parse("1.20"))) {
            PlayerProfile playerProfile = Bukkit.createPlayerProfile((UUID)meta.getOwningPlayer().getUniqueId(), (String)PLAYER_NAME);
            PlayerTextures playerTextures = playerProfile.getTextures();
            playerTextures.setSkin(this.skinUrl);
            playerProfile.setTextures(playerTextures);
            meta.setOwnerProfile(playerProfile);
        } else {
            meta.setOwningPlayer(meta.getOwningPlayer());
        }
        ReflectionUtils.setFieldValue(meta, "profile", (Object)this);
    }
}

