/*
 * Decompiled with CFR 0.152.
 */
package me.char321.sfadvancements.libs.dough.protection;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import me.char321.sfadvancements.libs.dough.common.DoughLogger;
import me.char321.sfadvancements.libs.dough.protection.Interaction;
import me.char321.sfadvancements.libs.dough.protection.ProtectionLogger;
import me.char321.sfadvancements.libs.dough.protection.ProtectionModule;
import me.char321.sfadvancements.libs.dough.protection.loggers.CoreProtectLogger;
import me.char321.sfadvancements.libs.dough.protection.loggers.LogBlockLogger;
import me.char321.sfadvancements.libs.dough.protection.modules.BentoBoxProtectionModule;
import me.char321.sfadvancements.libs.dough.protection.modules.BlockLockerProtectionModule;
import me.char321.sfadvancements.libs.dough.protection.modules.ChestProtectProtectionModule;
import me.char321.sfadvancements.libs.dough.protection.modules.FactionsUUIDProtectionModule;
import me.char321.sfadvancements.libs.dough.protection.modules.FunnyGuildsProtectionModule;
import me.char321.sfadvancements.libs.dough.protection.modules.GriefPreventionProtectionModule;
import me.char321.sfadvancements.libs.dough.protection.modules.HuskTownsProtectionModule;
import me.char321.sfadvancements.libs.dough.protection.modules.LWCProtectionModule;
import me.char321.sfadvancements.libs.dough.protection.modules.LandsProtectionModule;
import me.char321.sfadvancements.libs.dough.protection.modules.LocketteProtectionModule;
import me.char321.sfadvancements.libs.dough.protection.modules.PlotSquaredProtectionModule;
import me.char321.sfadvancements.libs.dough.protection.modules.PreciousStonesProtectionModule;
import me.char321.sfadvancements.libs.dough.protection.modules.RedProtectProtectionModule;
import me.char321.sfadvancements.libs.dough.protection.modules.TownyProtectionModule;
import me.char321.sfadvancements.libs.dough.protection.modules.WorldGuardProtectionModule;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;

public final class ProtectionManager {
    private final Set<ProtectionModule> protectionModules = new HashSet<ProtectionModule>();
    private final Set<ProtectionLogger> protectionLoggers = new HashSet<ProtectionLogger>();
    private final Logger logger;

    public ProtectionManager(@Nonnull Plugin plugin) {
        this.logger = new DoughLogger(plugin.getServer(), "protection");
        this.logger.log(Level.INFO, "Loading Protection Modules...");
        this.logger.log(Level.INFO, "This may happen more than once.");
        this.loadModuleImplementations(plugin);
        this.loadLoggerImplementations(plugin);
    }

    @ParametersAreNonnullByDefault
    private void loadModuleImplementations(Plugin plugin) {
        PluginManager pm = plugin.getServer().getPluginManager();
        this.registerModule(pm, "WorldGuard", worldGuard -> new WorldGuardProtectionModule((Plugin)worldGuard));
        this.registerModule(pm, "Towny", towny -> new TownyProtectionModule((Plugin)towny));
        this.registerModule(pm, "GriefPrevention", griefPrevention -> new GriefPreventionProtectionModule((Plugin)griefPrevention));
        this.registerModule(pm, "LWC", lwc -> new LWCProtectionModule((Plugin)lwc));
        this.registerModule(pm, "PreciousStones", preciousStones -> new PreciousStonesProtectionModule((Plugin)preciousStones));
        this.registerModule(pm, "Lockette", lockette -> new LocketteProtectionModule((Plugin)lockette));
        this.registerModule(pm, "RedProtect", redProtect -> new RedProtectProtectionModule((Plugin)redProtect));
        this.registerModule(pm, "BentoBox", bentoBox -> new BentoBoxProtectionModule((Plugin)bentoBox));
        this.registerModule(pm, "BlockLocker", blockLocker -> new BlockLockerProtectionModule((Plugin)blockLocker));
        this.registerModule(pm, "Lands", lands -> new LandsProtectionModule((Plugin)lands, plugin));
        this.registerModule(pm, "ChestProtect", chestProtect -> new ChestProtectProtectionModule((Plugin)chestProtect));
        this.registerModule(pm, "Factions", factions -> new FactionsUUIDProtectionModule((Plugin)factions));
        this.registerModule(pm, "FunnyGuilds", funnyGuilds -> new FunnyGuildsProtectionModule((Plugin)funnyGuilds));
        this.registerModule(pm, "PlotSquared", plotSquared -> new PlotSquaredProtectionModule((Plugin)plotSquared));
        this.registerModule(pm, "HuskTowns", huskTowns -> new HuskTownsProtectionModule((Plugin)huskTowns));
        if (pm.isPluginEnabled("ProtectionStones")) {
            this.printModuleLoaded("ProtectionStones");
        }
        if (pm.isPluginEnabled("uSkyblock")) {
            this.printModuleLoaded("uSkyblock");
        }
    }

    @ParametersAreNonnullByDefault
    private void loadLoggerImplementations(Plugin plugin) {
        PluginManager pm = plugin.getServer().getPluginManager();
        if (pm.isPluginEnabled("CoreProtect")) {
            this.registerLogger(new CoreProtectLogger());
        }
        if (pm.isPluginEnabled("LogBlock")) {
            this.registerLogger(new LogBlockLogger());
        }
    }

    @ParametersAreNonnullByDefault
    public void registerLogger(String name, ProtectionLogger module) {
        this.protectionLoggers.add(module);
        this.printModuleLoaded(name);
    }

    @ParametersAreNonnullByDefault
    public void registerModule(PluginManager pm, String pluginName, Function<Plugin, ProtectionModule> constructor) {
        Plugin plugin = pm.getPlugin(pluginName);
        if (plugin != null && plugin.isEnabled()) {
            this.registerModule(plugin, constructor);
        }
    }

    @ParametersAreNonnullByDefault
    private void registerModule(Plugin plugin, Function<Plugin, ProtectionModule> constructor) {
        try {
            ProtectionModule module = constructor.apply(plugin);
            module.load();
            this.protectionModules.add(module);
            this.printModuleLoaded(module.getName() + " v" + module.getVersion());
        }
        catch (Throwable x) {
            this.logger.log(Level.SEVERE, x, () -> "An Error occured while registering the Protection Module: \"" + plugin.getName() + "\" v" + plugin.getDescription().getVersion());
        }
    }

    @ParametersAreNonnullByDefault
    public void registerLogger(ProtectionLogger module) {
        try {
            module.load();
            this.registerLogger(module.getName(), module);
        }
        catch (Throwable x) {
            this.logger.log(Level.SEVERE, x, () -> "An Error occured while registering the Protection Module: \"" + module.getName() + "\"");
        }
    }

    @ParametersAreNonnullByDefault
    private void printModuleLoaded(String module) {
        this.logger.log(Level.INFO, "Loaded Protection Module \"{0}\"", module);
    }

    @ParametersAreNonnullByDefault
    public boolean hasPermission(OfflinePlayer p, Block b, Interaction action) {
        return this.hasPermission(p, b.getLocation(), action);
    }

    @ParametersAreNonnullByDefault
    public boolean hasPermission(OfflinePlayer p, Location l, Interaction action) {
        for (ProtectionModule module : this.protectionModules) {
            try {
                if (module.hasPermission(p, l, action)) continue;
                return false;
            }
            catch (Exception | LinkageError x) {
                this.logger.log(Level.SEVERE, x, () -> "An Error occured while querying the Protection Module: \"" + module.getName() + " v" + module.getVersion() + "\"");
                return true;
            }
        }
        return true;
    }

    @ParametersAreNonnullByDefault
    public void logAction(OfflinePlayer p, Block b, Interaction action) {
        for (ProtectionLogger module : this.protectionLoggers) {
            try {
                module.logAction(p, b, action);
            }
            catch (Exception | LinkageError x) {
                this.logger.log(Level.SEVERE, x, () -> "An Error occured while logging for the Protection Module: \"" + module.getName() + "\"");
            }
        }
    }
}

