/*
 * Decompiled with CFR 0.152.
 */
package me.char321.sfadvancements.core;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.char321.sfadvancements.api.Advancement;
import me.char321.sfadvancements.api.criteria.Criterion;
import me.char321.sfadvancements.core.criteria.progress.PlayerProgress;
import org.bukkit.entity.Player;

public class AdvManager {
    private final Map<UUID, PlayerProgress> playerMap = new HashMap<UUID, PlayerProgress>();

    public boolean isCompleted(Player player, Advancement advancement) {
        return this.isCompleted(player.getUniqueId(), advancement);
    }

    public boolean isCompleted(UUID player, Advancement advancement) {
        PlayerProgress progress = this.getProgress(player);
        return progress.isCompleted(advancement.getKey());
    }

    public PlayerProgress getProgress(Player player) {
        return this.getProgress(player.getUniqueId());
    }

    public PlayerProgress getProgress(UUID player) {
        return this.playerMap.computeIfAbsent(player, PlayerProgress::get);
    }

    public int getCriterionProgress(UUID p, Criterion criterion) {
        return this.getProgress(p).getCriterionProgress(criterion);
    }

    public int getCriterionProgress(Player p, Criterion criterion) {
        return this.getCriterionProgress(p.getUniqueId(), criterion);
    }

    public Map<UUID, PlayerProgress> getPlayerMap() {
        return this.playerMap;
    }

    public void save() throws IOException {
        for (Map.Entry<UUID, PlayerProgress> entry : this.playerMap.entrySet()) {
            entry.getValue().save();
        }
    }
}

