/*
 * Decompiled with CFR 0.152.
 */
package me.char321.sfadvancements.libs.dough.protection.modules;

import java.util.UUID;
import javax.annotation.Nonnull;
import me.char321.sfadvancements.libs.dough.protection.Interaction;
import me.char321.sfadvancements.libs.dough.protection.ProtectionModule;
import net.william278.husktowns.api.HuskTownsAPI;
import net.william278.husktowns.claim.Position;
import net.william278.husktowns.claim.World;
import net.william278.husktowns.listener.Operation;
import net.william278.husktowns.user.OnlineUser;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.plugin.Plugin;

public class HuskTownsProtectionModule
implements ProtectionModule {
    private HuskTownsAPI huskTownsAPI;
    private final Plugin plugin;

    public HuskTownsProtectionModule(@Nonnull Plugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public void load() {
        this.huskTownsAPI = HuskTownsAPI.getInstance();
    }

    @Override
    public Plugin getPlugin() {
        return this.plugin;
    }

    @Override
    public boolean hasPermission(OfflinePlayer p, Location l, Interaction action) {
        if (!p.isOnline()) {
            return false;
        }
        return this.huskTownsAPI.isOperationAllowed(Operation.of((OnlineUser)this.getOnlineUser(p), (Operation.Type)this.getHuskTownsAction(action), (Position)this.getPosition(l)));
    }

    private OnlineUser getOnlineUser(OfflinePlayer p) {
        return this.huskTownsAPI.getOnlineUser(p.getPlayer());
    }

    private Position getPosition(Location l) {
        org.bukkit.World w = l.getWorld();
        return Position.at((double)l.getX(), (double)l.getY(), (double)l.getZ(), (World)World.of((UUID)w.getUID(), (String)w.getName(), (String)w.getEnvironment().name()));
    }

    @Nonnull
    public Operation.Type getHuskTownsAction(@Nonnull Interaction doughAction) {
        switch (doughAction) {
            case BREAK_BLOCK: {
                return Operation.Type.BLOCK_BREAK;
            }
            case PLACE_BLOCK: {
                return Operation.Type.BLOCK_PLACE;
            }
            case ATTACK_ENTITY: {
                return Operation.Type.PLAYER_DAMAGE_ENTITY;
            }
            case ATTACK_PLAYER: {
                return Operation.Type.PLAYER_DAMAGE_PLAYER;
            }
            case INTERACT_BLOCK: {
                return Operation.Type.BLOCK_INTERACT;
            }
        }
        return Operation.Type.ENTITY_INTERACT;
    }
}

